/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectMultiRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectMultiRowReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ReadOnlyDirectMultiRowReplicaRequestDeserializer
implements MessageDeserializer<ReadOnlyDirectMultiRowReplicaRequest> {
    private final ReadOnlyDirectMultiRowReplicaRequestBuilder msg;

    ReadOnlyDirectMultiRowReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readOnlyDirectMultiRowReplicaRequest();
    }

    public Class<ReadOnlyDirectMultiRowReplicaRequest> klass() {
        return ReadOnlyDirectMultiRowReplicaRequest.class;
    }

    public ReadOnlyDirectMultiRowReplicaRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.enlistmentConsistencyToken((Long)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("primaryKeys", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.primaryKeys((List<ByteBuffer>)tmp);
                reader.incrementState();
            }
            case 3: {
                int ordinalShifted = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType tmp = ordinalShifted == 0 ? null : RequestType.fromOrdinal(ordinalShifted - 1);
                this.msg.requestType(tmp);
                reader.incrementState();
            }
            case 4: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 5: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadOnlyDirectMultiRowReplicaRequest.class);
    }
}

