/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommand;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.ReadCommand;
import org.apache.ignite.internal.raft.WriteCommand;
import org.apache.ignite.internal.raft.service.CommandClosure;
import org.apache.ignite.internal.raft.service.RaftGroupListener;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.TxState;

public class ZonePartitionRaftListener
implements RaftGroupListener {
    private static final IgniteLogger LOG = Loggers.forClass(ZonePartitionRaftListener.class);

    public void onRead(Iterator<CommandClosure<ReadCommand>> iterator) {
        iterator.forEachRemaining(clo -> {
            Command command = clo.command();
            assert (false) : "No read commands expected, [cmd=" + String.valueOf(command) + "]";
        });
    }

    public void onWrite(Iterator<CommandClosure<WriteCommand>> iterator) {
        iterator.forEachRemaining(clo -> {
            Command command = clo.command();
            TransactionResult result = null;
            try {
                if (command instanceof FinishTxCommand) {
                    FinishTxCommand cmd = (FinishTxCommand)command;
                    result = new TransactionResult(cmd.commit() ? TxState.COMMITTED : TxState.ABORTED, cmd.commitTimestamp());
                } else {
                    LOG.debug("Message type " + String.valueOf(command.getClass()) + " is not supported by the zone partition RAFT listener yet", new Object[0]);
                }
            }
            catch (Throwable t) {
                LOG.error("Unknown error while processing command [commandIndex={}, commandTerm={}, command={}]", t, new Object[]{clo.index(), clo.index(), command});
                clo.result((Serializable)t);
                throw t;
            }
            clo.result(result);
        });
    }

    public void onSnapshotSave(Path path, Consumer<Throwable> doneClo) {
        throw new UnsupportedOperationException("Snapshotting is not implemented");
    }

    public boolean onSnapshotLoad(Path path) {
        throw new UnsupportedOperationException("Snapshotting is not implemented");
    }

    public void onShutdown() {
    }
}

