/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.BitSet;
import java.util.List;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverterImpl;
import org.apache.ignite.internal.sql.engine.exec.VirtualColumn;
import org.apache.ignite.internal.sql.engine.util.AbstractProjectedTuple;
import org.apache.ignite.internal.sql.engine.util.ExtendedFieldDeserializingProjectedTuple;
import org.apache.ignite.internal.sql.engine.util.FieldDeserializingProjectedTuple;
import org.apache.ignite.internal.sql.engine.util.FormatAwareProjectedTuple;

public class ProjectedTableRowConverterImpl
extends TableRowConverterImpl {
    private final int[] requiredColumnsMapping;
    private final BinaryTupleSchema fullTupleSchema;
    private final List<VirtualColumn> virtualColumns;

    ProjectedTableRowConverterImpl(SchemaRegistry schemaRegistry, BinaryTupleSchema fullTupleSchema, SchemaDescriptor schemaDescriptor, BitSet requiredColumns, List<VirtualColumn> extraColumns) {
        super(schemaRegistry, schemaDescriptor);
        this.fullTupleSchema = fullTupleSchema;
        this.virtualColumns = extraColumns;
        int size = requiredColumns.cardinality();
        this.requiredColumnsMapping = new int[size];
        int requiredIndex = 0;
        for (Column column : schemaDescriptor.columns()) {
            if (!requiredColumns.get(column.positionInRow())) continue;
            this.requiredColumnsMapping[requiredIndex++] = column.positionInRow();
        }
        for (VirtualColumn col : extraColumns) {
            this.requiredColumnsMapping[requiredIndex++] = col.columnIndex();
        }
    }

    @Override
    public <RowT> RowT toRow(ExecutionContext<RowT> ectx, BinaryRow tableRow, RowHandler.RowFactory<RowT> factory) {
        BinaryTuple tableTuple;
        boolean rowSchemaMatches = tableRow.schemaVersion() == this.schemaDescriptor.version();
        Object object = tableTuple = rowSchemaMatches ? new BinaryTuple(this.schemaDescriptor.length(), tableRow.tupleSlice()) : this.schemaRegistry.resolve(tableRow, this.schemaDescriptor);
        AbstractProjectedTuple tuple = !this.virtualColumns.isEmpty() ? new ExtendedFieldDeserializingProjectedTuple(this.fullTupleSchema, (InternalTuple)tableTuple, this.requiredColumnsMapping, this.virtualColumns) : (rowSchemaMatches ? new FormatAwareProjectedTuple((InternalTuple)tableTuple, this.requiredColumnsMapping) : new FieldDeserializingProjectedTuple(this.fullTupleSchema, (InternalTuple)tableTuple, this.requiredColumnsMapping));
        return factory.create(tuple);
    }
}

