/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.jetbrains.annotations.Nullable;

public class InternalSqlRowSingleString
implements InternalSqlRow {
    private final String val;
    private BinaryTuple row;

    public InternalSqlRowSingleString(@Nullable String string) {
        this.val = string;
    }

    @Override
    @Nullable
    public String get(int idx) {
        assert (idx == 0);
        return this.val;
    }

    @Override
    public int fieldCount() {
        return 1;
    }

    @Override
    public BinaryTuple asBinaryTuple() {
        if (this.row == null) {
            int estimatedSize = this.val == null ? 0 : this.val.length();
            boolean exactEstimate = this.val == null;
            ByteBuffer buffer = new BinaryTupleBuilder(1, estimatedSize, exactEstimate).appendString(this.val).build();
            this.row = new BinaryTuple(1, buffer);
        }
        return this.row;
    }
}

