/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.Node;
import org.apache.ignite.internal.distributionzones.NodeSerializer;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class AugmentationSerializer
extends VersionedSerializer<DistributionZoneManager.Augmentation> {
    public static final AugmentationSerializer INSTANCE = new AugmentationSerializer();
    private final NodeSerializer nodeSerializer = NodeSerializer.INSTANCE;

    protected void writeExternalData(DistributionZoneManager.Augmentation augmentation, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)augmentation.nodes().size());
        for (Node node : augmentation.nodes()) {
            this.nodeSerializer.writeExternal(node, out);
        }
        out.writeBoolean(augmentation.addition());
    }

    protected DistributionZoneManager.Augmentation readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        Set<Node> nodes = this.readNodes(in);
        boolean addition = in.readBoolean();
        return new DistributionZoneManager.Augmentation(nodes, addition);
    }

    private Set<Node> readNodes(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        HashSet<Node> nodes = new HashSet<Node>(IgniteUtils.capacity((int)length));
        for (int i = 0; i < length; ++i) {
            nodes.add((Node)this.nodeSerializer.readExternal(in));
        }
        return nodes;
    }
}

