/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaResponse;
import org.apache.ignite.internal.tx.impl.PlacementDriverHelper;
import org.apache.ignite.internal.tx.impl.TxManagerImpl;
import org.apache.ignite.internal.tx.impl.TxMessageSender;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.jetbrains.annotations.Nullable;

public class WriteIntentSwitchProcessor {
    private static final IgniteLogger LOG = Loggers.forClass(WriteIntentSwitchProcessor.class);
    private final PlacementDriverHelper placementDriverHelper;
    private final TxMessageSender txMessageSender;
    private final TopologyService topologyService;

    public WriteIntentSwitchProcessor(PlacementDriverHelper placementDriverHelper, TxMessageSender txMessageSender, TopologyService topologyService) {
        this.placementDriverHelper = placementDriverHelper;
        this.txMessageSender = txMessageSender;
        this.topologyService = topologyService;
    }

    public CompletableFuture<ReplicaResponse> switchLocalWriteIntents(TablePartitionId tablePartitionId, UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        String localNodeName = this.topologyService.localMember().name();
        return this.txMessageSender.switchWriteIntents(localNodeName, tablePartitionId, txId, commit, commitTimestamp);
    }

    public CompletableFuture<ReplicaResponse> switchWriteIntentsWithRetry(boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId, TablePartitionId partitionId) {
        return ((CompletableFuture)((CompletableFuture)this.placementDriverHelper.awaitPrimaryReplicaWithExceptionHandling(partitionId).thenCompose(leaseHolder -> this.txMessageSender.switchWriteIntents(leaseHolder.getLeaseholder(), partitionId, txId, commit, commitTimestamp))).handle((res, ex) -> {
            if (ex != null) {
                Throwable cause = ExceptionUtils.unwrapCause((Throwable)ex);
                if (TxManagerImpl.TransactionFailureHandler.isRecoverable(cause)) {
                    LOG.info("Failed to switch write intents for Tx. The operation will be retried [txId={}].", new Object[]{txId, ex});
                    return this.switchWriteIntentsWithRetry(commit, commitTimestamp, txId, partitionId);
                }
                LOG.info("Failed to switch write intents for Tx [txId={}].", new Object[]{txId, ex});
                return CompletableFuture.failedFuture(ex);
            }
            return CompletableFutures.nullCompletedFuture();
        })).thenCompose(Function.identity());
    }
}

