/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class DropSchemaEntry
implements UpdateEntry {
    public static final CatalogObjectSerializer<DropSchemaEntry> SERIALIZER = new DropSchemaSerializer();
    private final int schemaId;

    public DropSchemaEntry(int schemaId) {
        this.schemaId = schemaId;
    }

    public int schemaId() {
        return this.schemaId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_SCHEMA.id();
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), catalog.schemas().stream().filter(s -> s.id() != this.schemaId).collect(Collectors.toList()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class DropSchemaSerializer
    implements CatalogObjectSerializer<DropSchemaEntry> {
        private DropSchemaSerializer() {
        }

        @Override
        public DropSchemaEntry readFrom(IgniteDataInput input) throws IOException {
            int schemaId = input.readVarIntAsInt();
            return new DropSchemaEntry(schemaId);
        }

        @Override
        public void writeTo(DropSchemaEntry entry, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)entry.schemaId());
        }
    }
}

