/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Described;
import io.micronaut.core.type.Argument;
import java.util.Arrays;
import java.util.stream.Collectors;

public interface BeanConstructor<T>
extends AnnotationMetadataProvider,
Described {
    @NonNull
    public Class<T> getDeclaringBeanType();

    @NonNull
    public Argument<?>[] getArguments();

    @NonNull
    public T instantiate(Object ... var1);

    @Override
    @NonNull
    default public String getDescription() {
        return this.getDescription(true);
    }

    @Override
    @NonNull
    default public String getDescription(boolean simple) {
        String args = Arrays.stream(this.getArguments()).map(arg -> arg.getTypeString(simple) + " " + arg.getName()).collect(Collectors.joining(","));
        return this.getDeclaringBeanType().getSimpleName() + "(" + args + ")";
    }
}

