/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles;

import org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles.DoubleComparator;

public final class DoubleHeaps {
    private DoubleHeaps() {
    }

    public static int downHeap(double[] heap, int size, int i, DoubleComparator c) {
        assert (i < size);
        double e = heap[i];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size) {
                double t2 = heap[child];
                int right = child + 1;
                if (right < size && Double.compare(heap[right], t2) < 0) {
                    child = right;
                    t2 = heap[child];
                }
                if (Double.compare(e, t2) > 0) {
                    heap[i] = t2;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size) {
                double t3 = heap[child];
                int right = child + 1;
                if (right < size && c.compare(heap[right], t3) < 0) {
                    child = right;
                    t3 = heap[child];
                }
                if (c.compare(e, t3) > 0) {
                    heap[i] = t3;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(double[] heap, int size, int i, DoubleComparator c) {
        assert (i < size);
        double e = heap[i];
        if (c == null) {
            int parent;
            double t2;
            while (i != 0 && Double.compare(t2 = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t2;
                i = parent;
            }
        } else {
            int parent;
            double t3;
            while (i != 0 && c.compare(t3 = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t3;
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(double[] heap, int size, DoubleComparator c) {
        int i = size >>> 1;
        while (i-- != 0) {
            DoubleHeaps.downHeap(heap, size, i, c);
        }
    }
}

