/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.basic;

import org.apache.ignite.internal.storage.DataRow;
import org.apache.ignite.internal.storage.InvokeClosure;
import org.apache.ignite.internal.storage.OperationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetAndReplaceInvokeClosure
implements InvokeClosure<Boolean> {
    @NotNull
    private final DataRow newRow;
    private final boolean onlyIfExists;
    @Nullable
    private DataRow oldRow;
    private boolean replaces;

    public GetAndReplaceInvokeClosure(@NotNull DataRow newRow, boolean onlyIfExists) {
        this.newRow = newRow;
        this.onlyIfExists = onlyIfExists;
    }

    @Override
    public void call(@Nullable DataRow row) {
        this.oldRow = row;
        this.replaces = row != null || !this.onlyIfExists;
    }

    @Override
    @Nullable
    public DataRow newRow() {
        return this.newRow;
    }

    @Override
    @Nullable
    public OperationType operationType() {
        return this.replaces ? OperationType.WRITE : OperationType.NOOP;
    }

    @Nullable
    public DataRow oldRow() {
        return this.oldRow;
    }

    @Override
    @NotNull
    public Boolean result() {
        return this.replaces;
    }
}

