/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.Ignite;
import org.apache.ignite.client.IgniteClientAddressFinder;
import org.apache.ignite.client.IgniteClientConfiguration;
import org.apache.ignite.client.RetryPolicy;
import org.apache.ignite.client.RetryReadPolicy;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.IgniteClientConfigurationImpl;
import org.apache.ignite.internal.client.TcpIgniteClient;
import org.apache.ignite.lang.LoggerFactory;
import org.apache.ignite.network.ClusterNode;

public interface IgniteClient
extends Ignite {
    public IgniteClientConfiguration configuration();

    public List<ClusterNode> connections();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String[] addresses;
        private IgniteClientAddressFinder addressFinder;
        private long connectTimeout = 5000L;
        private long reconnectThrottlingPeriod = 30000L;
        private int reconnectThrottlingRetries = 3;
        private Executor asyncContinuationExecutor;
        private long heartbeatInterval = 30000L;
        private RetryPolicy retryPolicy = new RetryReadPolicy();
        private LoggerFactory loggerFactory;

        public Builder addresses(String ... addrs) {
            Objects.requireNonNull(addrs, "addrs is null");
            this.addresses = (String[])addrs.clone();
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder loggerFactory(LoggerFactory loggerFactory) {
            this.loggerFactory = loggerFactory;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            if (connectTimeout < 0L) {
                throw new IllegalArgumentException("Connect timeout [" + connectTimeout + "] must be a non-negative integer value.");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder addressFinder(IgniteClientAddressFinder addressFinder) {
            this.addressFinder = addressFinder;
            return this;
        }

        public Builder reconnectThrottlingPeriod(long reconnectThrottlingPeriod) {
            this.reconnectThrottlingPeriod = reconnectThrottlingPeriod;
            return this;
        }

        public Builder reconnectThrottlingRetries(int reconnectThrottlingRetries) {
            if (reconnectThrottlingRetries < 0) {
                throw new IllegalArgumentException("Reconnect throttling retries [" + reconnectThrottlingRetries + "] must be a non-negative integer value.");
            }
            this.reconnectThrottlingRetries = reconnectThrottlingRetries;
            return this;
        }

        public Builder asyncContinuationExecutor(Executor asyncContinuationExecutor) {
            this.asyncContinuationExecutor = asyncContinuationExecutor;
            return this;
        }

        public Builder heartbeatInterval(long heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        public IgniteClient build() {
            return ClientUtils.sync(this.buildAsync());
        }

        public CompletableFuture<IgniteClient> buildAsync() {
            IgniteClientConfigurationImpl cfg = new IgniteClientConfigurationImpl(this.addressFinder, this.addresses, this.connectTimeout, this.reconnectThrottlingPeriod, this.reconnectThrottlingRetries, this.asyncContinuationExecutor, this.heartbeatInterval, this.retryPolicy, this.loggerFactory);
            return TcpIgniteClient.startAsync(cfg);
        }
    }
}

