/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.set;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;

public abstract class IgniteMinusBase
extends Minus
implements TraitsAwareIgniteRel {
    protected static final int COUNTER_FIELDS_CNT = 2;

    IgniteMinusBase(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, all);
    }

    protected IgniteMinusBase(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RelCollations.EMPTY))));
    }

    protected abstract int aggregateFieldsCount();

    public double estimateRowCount(RelMetadataQuery mq) {
        List inputs = this.getInputs();
        double rows = mq.getRowCount((RelNode)inputs.get(0));
        for (int i = 1; i < inputs.size(); ++i) {
            rows -= 0.5 * Math.min(rows, mq.getRowCount((RelNode)inputs.get(i)));
        }
        return rows;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double rows = this.estimateRowCount(mq);
        double inputRows = 0.0;
        for (RelNode input : this.getInputs()) {
            inputRows += mq.getRowCount(input).doubleValue();
        }
        double mem = 0.5 * inputRows * (double)this.aggregateFieldsCount() * 4.0;
        return costFactory.makeCost(rows, inputRows * 1.0, 0.0, mem, 0.0);
    }
}

