/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.persistence;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.metastorage.common.MetaStorageException;
import org.apache.ignite.internal.metastorage.server.Condition;
import org.apache.ignite.internal.metastorage.server.Entry;
import org.apache.ignite.internal.metastorage.server.If;
import org.apache.ignite.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite.internal.metastorage.server.Operation;
import org.apache.ignite.internal.metastorage.server.Statement;
import org.apache.ignite.internal.metastorage.server.StatementResult;
import org.apache.ignite.internal.metastorage.server.Update;
import org.apache.ignite.internal.metastorage.server.Value;
import org.apache.ignite.internal.metastorage.server.WatchEvent;
import org.apache.ignite.internal.metastorage.server.persistence.RangeCursor;
import org.apache.ignite.internal.metastorage.server.persistence.RocksStorageUtils;
import org.apache.ignite.internal.metastorage.server.persistence.StorageColumnFamilyType;
import org.apache.ignite.internal.metastorage.server.persistence.WatchCursor;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksBiPredicate;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.rocksdb.snapshot.ColumnFamilyRange;
import org.apache.ignite.internal.rocksdb.snapshot.RocksSnapshotManager;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDbKeyValueStorage
implements KeyValueStorage {
    private static final long SYSTEM_REVISION_MARKER_VALUE = 0L;
    private static final byte[] REVISION_KEY = RocksStorageUtils.keyToRocksKey(0L, "SYSTEM_REVISION_KEY".getBytes(StandardCharsets.UTF_8));
    private static final byte[] UPDATE_COUNTER_KEY = RocksStorageUtils.keyToRocksKey(0L, "SYSTEM_UPDATE_COUNTER_KEY".getBytes(StandardCharsets.UTF_8));
    private static final long LATEST_REV = -1L;
    static final Comparator<byte[]> CMP = Arrays::compare;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ExecutorService snapshotExecutor = Executors.newFixedThreadPool(2);
    private final Path dbPath;
    private volatile DBOptions options;
    private volatile RocksDB db;
    private volatile ColumnFamily data;
    private volatile ColumnFamily index;
    private volatile RocksSnapshotManager snapshotManager;
    private volatile long rev;
    private volatile long updCntr;

    public RocksDbKeyValueStorage(Path dbPath) {
        this.dbPath = dbPath;
    }

    @Override
    public void start() {
        try {
            this.recreateDb();
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.STARTING_STORAGE_ERR, "Failed to start the storage", (Throwable)e);
        }
    }

    private static List<ColumnFamilyDescriptor> cfDescriptors() {
        Options dataOptions = new Options().setCreateIfMissing(true).useFixedLengthPrefixExtractor(8);
        ColumnFamilyOptions dataFamilyOptions = new ColumnFamilyOptions(dataOptions);
        Options indexOptions = new Options().setCreateIfMissing(true);
        ColumnFamilyOptions indexFamilyOptions = new ColumnFamilyOptions(indexOptions);
        return List.of(new ColumnFamilyDescriptor(StorageColumnFamilyType.DATA.nameAsBytes(), dataFamilyOptions), new ColumnFamilyDescriptor(StorageColumnFamilyType.INDEX.nameAsBytes(), indexFamilyOptions));
    }

    private void recreateDb() throws RocksDBException {
        this.destroyRocksDb();
        List<ColumnFamilyDescriptor> descriptors = RocksDbKeyValueStorage.cfDescriptors();
        assert (descriptors.size() == 2);
        ArrayList handles = new ArrayList(descriptors.size());
        this.options = new DBOptions().setCreateMissingColumnFamilies(true).setCreateIfMissing(true);
        this.db = RocksDB.open((DBOptions)this.options, (String)this.dbPath.toAbsolutePath().toString(), descriptors, handles);
        this.data = ColumnFamily.wrap((RocksDB)this.db, (ColumnFamilyHandle)((ColumnFamilyHandle)handles.get(0)));
        this.index = ColumnFamily.wrap((RocksDB)this.db, (ColumnFamilyHandle)((ColumnFamilyHandle)handles.get(1)));
        this.snapshotManager = new RocksSnapshotManager(this.db, List.of(ColumnFamilyRange.fullRange((ColumnFamily)this.data), ColumnFamilyRange.fullRange((ColumnFamily)this.index)), (Executor)this.snapshotExecutor);
    }

    private void destroyRocksDb() throws RocksDBException {
        try (Options opt = new Options();){
            RocksDB.destroyDB((String)this.dbPath.toString(), (Options)opt);
        }
    }

    @Override
    public void close() throws Exception {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.snapshotExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.db, this.options});
    }

    @Override
    public CompletableFuture<Void> snapshot(Path snapshotPath) {
        return this.snapshotManager.createSnapshot(snapshotPath);
    }

    @Override
    public void restoreSnapshot(Path path) {
        this.rwLock.writeLock().lock();
        try {
            IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.db, this.options});
            this.recreateDb();
            this.snapshotManager.restoreSnapshot(path);
            this.rev = RocksStorageUtils.bytesToLong(this.data.get(REVISION_KEY));
            this.updCntr = RocksStorageUtils.bytesToLong(this.data.get(UPDATE_COUNTER_KEY));
        }
        catch (Exception e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.RESTORING_STORAGE_ERR, "Failed to restore snapshot", (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public long revision() {
        return this.rev;
    }

    @Override
    public long updateCounter() {
        return this.updCntr;
    }

    @Override
    public void put(byte[] key, byte[] value) {
        this.rwLock.writeLock().lock();
        try (WriteBatch batch = new WriteBatch();){
            long curRev = this.rev + 1L;
            long cntr = this.updCntr + 1L;
            this.addDataToBatch(batch, key, value, curRev, cntr);
            this.updateKeysIndex(batch, key, curRev);
            this.fillAndWriteBatch(batch, curRev, cntr);
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void updateKeysIndex(WriteBatch batch, byte[] key, long curRev) {
        try {
            byte @Nullable [] array = this.index.get(key);
            this.index.put(batch, key, RocksStorageUtils.appendLong(array, curRev));
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
    }

    private void fillAndWriteBatch(WriteBatch batch, long newRev, long newCntr) throws RocksDBException {
        try (WriteOptions opts = new WriteOptions();){
            this.data.put(batch, UPDATE_COUNTER_KEY, RocksStorageUtils.longToBytes(newCntr));
            this.data.put(batch, REVISION_KEY, RocksStorageUtils.longToBytes(newRev));
            this.db.write(opts, batch);
            this.rev = newRev;
            this.updCntr = newCntr;
        }
    }

    @Override
    @NotNull
    public Entry getAndPut(byte[] key, byte[] value) {
        this.rwLock.writeLock().lock();
        try {
            Entry entry;
            WriteBatch batch = new WriteBatch();
            try {
                long curRev = this.rev + 1L;
                long cntr = this.updCntr + 1L;
                long[] revs = this.getRevisions(key);
                long lastRev = revs.length == 0 ? 0L : RocksDbKeyValueStorage.lastRevision(revs);
                this.addDataToBatch(batch, key, value, curRev, cntr);
                this.updateKeysIndex(batch, key, curRev);
                this.fillAndWriteBatch(batch, curRev, cntr);
                entry = this.doGetValue(key, lastRev);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        batch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
                }
            }
            batch.close();
            return entry;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void putAll(List<byte[]> keys, List<byte[]> values) {
        this.rwLock.writeLock().lock();
        try (WriteBatch batch = new WriteBatch();){
            long curRev = this.rev + 1L;
            long counter = this.addAllToBatch(batch, keys, values, curRev);
            for (byte[] key : keys) {
                this.updateKeysIndex(batch, key, curRev);
            }
            this.fillAndWriteBatch(batch, curRev, counter);
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    @NotNull
    public Collection<Entry> getAndPutAll(List<byte[]> keys, List<byte[]> values) {
        Collection<Entry> res;
        this.rwLock.writeLock().lock();
        try (WriteBatch batch = new WriteBatch();){
            long curRev = this.rev + 1L;
            res = this.doGetAll(keys, curRev);
            long counter = this.addAllToBatch(batch, keys, values, curRev);
            for (byte[] key : keys) {
                this.updateKeysIndex(batch, key, curRev);
            }
            this.fillAndWriteBatch(batch, curRev, counter);
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        return res;
    }

    @Override
    @NotNull
    public Entry get(byte[] key) {
        this.rwLock.readLock().lock();
        try {
            Entry entry = this.doGet(key, -1L);
            return entry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Entry get(byte[] key, long revUpperBound) {
        this.rwLock.readLock().lock();
        try {
            Entry entry = this.doGet(key, revUpperBound);
            return entry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    @NotNull
    public Collection<Entry> getAll(List<byte[]> keys) {
        return this.doGetAll(keys, -1L);
    }

    @Override
    @NotNull
    public Collection<Entry> getAll(List<byte[]> keys, long revUpperBound) {
        return this.doGetAll(keys, revUpperBound);
    }

    @Override
    public void remove(byte[] key) {
        this.rwLock.writeLock().lock();
        try (WriteBatch batch = new WriteBatch();){
            long curRev = this.rev + 1L;
            long counter = this.updCntr + 1L;
            if (this.addToBatchForRemoval(batch, key, curRev, counter)) {
                this.updateKeysIndex(batch, key, curRev);
                this.fillAndWriteBatch(batch, curRev, counter);
            }
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Entry getAndRemove(byte[] key) {
        this.rwLock.writeLock().lock();
        try {
            Entry e = this.doGet(key, -1L);
            if (e.empty() || e.tombstone()) {
                Entry entry = e;
                return entry;
            }
            Entry entry = this.getAndPut(key, Value.TOMBSTONE);
            return entry;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void removeAll(List<byte[]> keys) {
        this.rwLock.writeLock().lock();
        try (WriteBatch batch = new WriteBatch();){
            long curRev = this.rev + 1L;
            ArrayList<byte[]> existingKeys = new ArrayList<byte[]>(keys.size());
            long counter = this.updCntr;
            for (byte[] key : keys) {
                if (!this.addToBatchForRemoval(batch, key, curRev, counter + 1L)) continue;
                existingKeys.add(key);
                ++counter;
            }
            for (byte[] key : existingKeys) {
                this.updateKeysIndex(batch, key, curRev);
            }
            this.fillAndWriteBatch(batch, curRev, counter);
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    @NotNull
    public Collection<Entry> getAndRemoveAll(List<byte[]> keys) {
        ArrayList<Entry> res = new ArrayList<Entry>(keys.size());
        this.rwLock.writeLock().lock();
        try (WriteBatch batch = new WriteBatch();){
            long curRev = this.rev + 1L;
            ArrayList<byte[]> existingKeys = new ArrayList<byte[]>(keys.size());
            ArrayList<byte[]> vals = new ArrayList<byte[]>(keys.size());
            for (byte[] key : keys) {
                Entry e = this.doGet(key, -1L);
                res.add(e);
                if (e.empty() || e.tombstone()) continue;
                existingKeys.add(key);
                vals.add(Value.TOMBSTONE);
            }
            long counter = this.addAllToBatch(batch, existingKeys, vals, curRev);
            for (byte[] key : existingKeys) {
                this.updateKeysIndex(batch, key, curRev);
            }
            this.fillAndWriteBatch(batch, curRev, counter);
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        return res;
    }

    @Override
    public boolean invoke(Condition condition, Collection<Operation> success, Collection<Operation> failure) {
        this.rwLock.writeLock().lock();
        try {
            Entry[] entries = this.getAll(Arrays.asList(condition.keys())).toArray(new Entry[0]);
            boolean branch = condition.test(entries);
            Collection<Operation> ops = branch ? success : failure;
            this.applyOperations(ops);
            boolean bl = branch;
            return bl;
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StatementResult invoke(If iif) {
        this.rwLock.writeLock().lock();
        try {
            If currIf = iif;
            byte maximumNumOfNestedBranch = 100;
            while (true) {
                Statement branch;
                byte by = maximumNumOfNestedBranch;
                maximumNumOfNestedBranch = (byte)(maximumNumOfNestedBranch - 1);
                if (by <= 0) {
                    throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, "Too many nested (" + maximumNumOfNestedBranch + ") statements in multi-invoke command.");
                }
                Entry[] entries = this.getAll(Arrays.asList(currIf.cond().keys())).toArray(new Entry[0]);
                Statement statement = branch = currIf.cond().test(entries) ? currIf.andThen() : currIf.orElse();
                if (branch.isTerminal()) {
                    Update update = branch.update();
                    this.applyOperations(update.operations());
                    StatementResult statementResult = update.result();
                    return statementResult;
                }
                currIf = branch.iif();
                continue;
                break;
            }
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void applyOperations(Collection<Operation> ops) throws RocksDBException {
        long curRev = this.rev + 1L;
        boolean modified = false;
        long counter = this.updCntr;
        ArrayList<byte[]> updatedKeys = new ArrayList<byte[]>();
        try (WriteBatch batch = new WriteBatch();){
            block10: for (Operation op : ops) {
                byte[] key = op.key();
                switch (op.type()) {
                    case PUT: {
                        this.addDataToBatch(batch, key, op.value(), curRev, ++counter);
                        updatedKeys.add(key);
                        modified = true;
                        continue block10;
                    }
                    case REMOVE: {
                        boolean removed = this.addToBatchForRemoval(batch, key, curRev, ++counter);
                        if (!removed) {
                            --counter;
                        } else {
                            updatedKeys.add(key);
                        }
                        modified |= removed;
                        continue block10;
                    }
                    case NO_OP: {
                        continue block10;
                    }
                }
                throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, "Unknown operation type: " + op.type());
            }
            if (modified) {
                for (byte[] key : updatedKeys) {
                    this.updateKeysIndex(batch, key, curRev);
                }
                this.fillAndWriteBatch(batch, curRev, counter);
            }
        }
    }

    @Override
    public Cursor<Entry> range(byte[] keyFrom, byte[] keyTo, boolean includeTombstones) {
        return new RangeCursor(this, keyFrom, keyTo, this.rev, includeTombstones);
    }

    @Override
    public Cursor<Entry> range(byte[] keyFrom, byte[] keyTo, long revUpperBound, boolean includeTombstones) {
        return new RangeCursor(this, keyFrom, keyTo, revUpperBound, includeTombstones);
    }

    @Override
    public Cursor<WatchEvent> watch(byte[] keyFrom, byte @Nullable [] keyTo, long rev) {
        assert (keyFrom != null) : "keyFrom couldn't be null.";
        assert (rev > 0L) : "rev must be positive.";
        return new WatchCursor(this, rev, k -> CMP.compare(keyFrom, (byte[])k) <= 0 && (keyTo == null || CMP.compare((byte[])k, keyTo) < 0));
    }

    @Override
    public Cursor<WatchEvent> watch(byte[] key, long rev) {
        assert (key != null) : "key couldn't be null.";
        assert (rev > 0L) : "rev must be positive.";
        return new WatchCursor(this, rev, k -> CMP.compare((byte[])k, key) == 0);
    }

    @Override
    public Cursor<WatchEvent> watch(Collection<byte[]> keys, long rev) {
        assert (keys != null && !keys.isEmpty()) : "keys couldn't be null or empty: " + keys;
        assert (rev > 0L) : "rev must be positive.";
        TreeSet<byte[]> keySet = new TreeSet<byte[]>(CMP);
        keySet.addAll(keys);
        return new WatchCursor(this, rev, keySet::contains);
    }

    @Override
    public void compact() {
        this.rwLock.writeLock().lock();
        try (WriteBatch batch = new WriteBatch();){
            try (RocksIterator iterator = this.index.newIterator();){
                iterator.seekToFirst();
                RocksUtils.forEach((RocksIterator)iterator, (key, value) -> this.compactForKey(batch, key, RocksStorageUtils.getAsLongs(value)));
            }
            this.fillAndWriteBatch(batch, this.rev, this.updCntr);
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.COMPACTION_ERR, (Throwable)e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private boolean addToBatchForRemoval(WriteBatch batch, byte[] key, long curRev, long counter) throws RocksDBException {
        Entry e = this.doGet(key, -1L);
        if (e.empty() || e.tombstone()) {
            return false;
        }
        this.addDataToBatch(batch, key, Value.TOMBSTONE, curRev, counter);
        return true;
    }

    private void compactForKey(WriteBatch batch, byte[] key, long[] revs) throws RocksDBException {
        long lastRev = RocksDbKeyValueStorage.lastRevision(revs);
        for (int i = 0; i < revs.length - 1; ++i) {
            this.data.delete(batch, RocksStorageUtils.keyToRocksKey(revs[i], key));
        }
        byte[] rocksKey = RocksStorageUtils.keyToRocksKey(lastRev, key);
        Value value = RocksStorageUtils.bytesToValue(this.data.get(rocksKey));
        if (value.tombstone()) {
            this.index.delete(batch, rocksKey);
            this.index.delete(batch, key);
        } else {
            this.index.put(batch, key, RocksStorageUtils.longToBytes(lastRev));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Collection<Entry> doGetAll(Collection<byte[]> keys, long rev) {
        assert (keys != null) : "keys list can't be null.";
        assert (!keys.isEmpty()) : "keys list can't be empty.";
        assert (rev > 0L || rev == -1L) : "Revision must be positive or -1.";
        ArrayList<Entry> res = new ArrayList<Entry>(keys.size());
        this.rwLock.readLock().lock();
        try {
            for (byte[] key : keys) {
                res.add(this.doGet(key, rev));
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return res;
    }

    @NotNull
    Entry doGet(byte[] key, long revUpperBound) {
        long[] revs;
        assert (revUpperBound >= -1L) : "Invalid arguments: [revUpperBound=" + revUpperBound + "]";
        try {
            revs = this.getRevisions(key);
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        if (revs == null || revs.length == 0) {
            return Entry.empty(key);
        }
        long lastRev = revUpperBound == -1L ? RocksDbKeyValueStorage.lastRevision(revs) : RocksDbKeyValueStorage.maxRevision(revs, revUpperBound);
        if (lastRev == -1L) {
            return Entry.empty(key);
        }
        return this.doGetValue(key, lastRev);
    }

    private long[] getRevisions(byte[] key) throws RocksDBException {
        byte[] revisions = this.index.get(key);
        if (revisions == null) {
            return ArrayUtils.LONG_EMPTY_ARRAY;
        }
        return RocksStorageUtils.getAsLongs(revisions);
    }

    static long maxRevision(long[] revs, long upperBoundRev) {
        for (int i = revs.length - 1; i >= 0; --i) {
            long rev = revs[i];
            if (rev > upperBoundRev) continue;
            return rev;
        }
        return -1L;
    }

    @NotNull
    Entry doGetValue(byte[] key, long revision) {
        byte[] valueBytes;
        if (revision == 0L) {
            return Entry.empty(key);
        }
        try {
            valueBytes = this.data.get(RocksStorageUtils.keyToRocksKey(revision, key));
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
        if (valueBytes == null || valueBytes.length == 0) {
            return Entry.empty(key);
        }
        Value lastVal = RocksStorageUtils.bytesToValue(valueBytes);
        if (lastVal.tombstone()) {
            return Entry.tombstone(key, revision, lastVal.updateCounter());
        }
        return new Entry(key, lastVal.bytes(), revision, lastVal.updateCounter());
    }

    private void addDataToBatch(WriteBatch batch, byte[] key, byte[] value, long curRev, long cntr) throws RocksDBException {
        byte[] rocksKey = RocksStorageUtils.keyToRocksKey(curRev, key);
        byte[] rocksValue = RocksStorageUtils.valueToBytes(value, cntr);
        this.data.put(batch, rocksKey, rocksValue);
    }

    private long addAllToBatch(WriteBatch batch, List<byte[]> keys, List<byte[]> values, long curRev) throws RocksDBException {
        long counter = this.updCntr;
        for (int i = 0; i < keys.size(); ++i) {
            byte[] key = keys.get(i);
            byte[] bytes = values.get(i);
            this.addDataToBatch(batch, key, bytes, curRev, ++counter);
        }
        return counter;
    }

    @Nullable
    Map.Entry<byte[], long[]> revisionCeilingEntry(byte[] keyFrom) {
        return this.higherOrCeiling(keyFrom, false);
    }

    @Nullable
    Map.Entry<byte[], long[]> revisionHigherEntry(byte[] key) {
        return this.higherOrCeiling(key, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private IgniteBiTuple<byte[], long[]> higherOrCeiling(byte[] key, boolean strictlyHigher) {
        try (RocksIterator iterator = this.index.newIterator();){
            iterator.seek(key);
            RocksBiPredicate predicate = strictlyHigher ? (k, v) -> CMP.compare(k, key) > 0 : (k, v) -> CMP.compare(k, key) >= 0;
            boolean found = RocksUtils.find((RocksIterator)iterator, (RocksBiPredicate)predicate);
            if (!found) {
                IgniteBiTuple<byte[], long[]> igniteBiTuple2 = null;
                return igniteBiTuple2;
            }
            IgniteBiTuple igniteBiTuple = new IgniteBiTuple((Object)iterator.key(), (Object)RocksStorageUtils.getAsLongs(iterator.value()));
            return igniteBiTuple;
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, (Throwable)e);
        }
    }

    public RocksIterator newDataIterator(ReadOptions options) {
        return this.data.newIterator(options);
    }

    private static long lastRevision(long[] revs) {
        return revs[revs.length - 1];
    }

    ReadWriteLock lock() {
        return this.rwLock;
    }

    RocksDB db() {
        return this.db;
    }

    @TestOnly
    public Path getDbPath() {
        return this.dbPath;
    }

    static {
        RocksDB.loadLibrary();
    }
}

