/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.node.metric;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.StringCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.rest.client.api.NodeMetricApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.Configuration;
import org.apache.ignite.rest.client.model.MetricSource;

@Singleton
public class NodeMetricListCall
implements Call<StringCallInput, List<MetricSource>> {
    @Override
    public CallOutput<List<MetricSource>> execute(StringCallInput input) {
        try {
            return DefaultCallOutput.success(NodeMetricListCall.listNodeMetrics(input));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getString()));
        }
    }

    private static List<MetricSource> listNodeMetrics(StringCallInput input) throws ApiException {
        return new NodeMetricApi(Configuration.getDefaultApiClient().setBasePath(input.getString())).listNodeMetrics();
    }
}

