/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.visitor;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.inject.visitor.BeanElementVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class BeanElementVisitorLoader {
    BeanElementVisitorLoader() {
    }

    @NonNull
    static List<BeanElementVisitor<?>> load() {
        ArrayList<BeanElementVisitor> visitors = new ArrayList<BeanElementVisitor>(10);
        SoftServiceLoader serviceLoader = SoftServiceLoader.load(BeanElementVisitor.class);
        for (ServiceDefinition definition : serviceLoader) {
            if (!definition.isPresent()) continue;
            try {
                BeanElementVisitor visitor = (BeanElementVisitor)definition.load();
                if (!visitor.isEnabled()) continue;
                visitors.add(visitor);
            }
            catch (Exception exception) {}
        }
        if (visitors.isEmpty()) {
            return Collections.emptyList();
        }
        OrderUtil.sort(visitors);
        return Collections.unmodifiableList(visitors);
    }
}

