/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.index;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.configuration.ColumnTypeView;
import org.apache.ignite.internal.schema.configuration.ColumnView;
import org.apache.ignite.internal.schema.configuration.ConfigurationToSchemaDescriptorConverter;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesView;
import org.apache.ignite.internal.schema.configuration.index.HashIndexView;
import org.apache.ignite.internal.schema.configuration.index.TableIndexView;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.IndexDescriptor;
import org.apache.ignite.internal.tostring.S;

public class HashIndexDescriptor
implements IndexDescriptor {
    private final UUID id;
    private final List<HashIndexColumnDescriptor> columns;

    public HashIndexDescriptor(UUID indexId, TablesView tablesConfig) {
        this(indexId, HashIndexDescriptor.extractIndexColumnsConfiguration(indexId, tablesConfig));
    }

    public HashIndexDescriptor(UUID indexId, List<HashIndexColumnDescriptor> columns) {
        this.id = indexId;
        this.columns = columns;
    }

    private static List<HashIndexColumnDescriptor> extractIndexColumnsConfiguration(UUID indexId, TablesView tablesConfig) {
        TableIndexView indexConfig = (TableIndexView)ConfigurationUtil.getByInternalId((NamedListView)tablesConfig.indexes(), (UUID)indexId);
        if (indexConfig == null) {
            throw new StorageException(String.format("Index configuration for \"%s\" could not be found", indexId));
        }
        if (!(indexConfig instanceof HashIndexView)) {
            throw new StorageException(String.format("Index \"%s\" is not configured as a Hash Index. Actual type: %s", indexConfig.id(), indexConfig.type()));
        }
        TableView tableConfig = (TableView)ConfigurationUtil.getByInternalId((NamedListView)tablesConfig.tables(), (UUID)indexConfig.tableId());
        if (tableConfig == null) {
            throw new StorageException(String.format("Table configuration for \"%s\" could not be found", indexConfig.tableId()));
        }
        String[] indexColumns = ((HashIndexView)indexConfig).columnNames();
        return Arrays.stream(indexColumns).map(columnName -> {
            ColumnView columnView = (ColumnView)tableConfig.columns().get(columnName);
            assert (columnView != null) : "Incorrect index column configuration. " + columnName + " column does not exist";
            return new HashIndexColumnDescriptor(columnView);
        }).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public UUID id() {
        return this.id;
    }

    public List<HashIndexColumnDescriptor> columns() {
        return this.columns;
    }

    public static class HashIndexColumnDescriptor
    implements IndexDescriptor.ColumnDescriptor {
        private final String name;
        private final NativeType type;
        private final boolean nullable;

        public HashIndexColumnDescriptor(String name, NativeType type, boolean nullable) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
        }

        HashIndexColumnDescriptor(ColumnView tableColumnView) {
            this.name = tableColumnView.name();
            this.type = ConfigurationToSchemaDescriptorConverter.convert((ColumnTypeView)tableColumnView.type());
            this.nullable = tableColumnView.nullable();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public NativeType type() {
            return this.type;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }
}

