/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.dump;

import java.io.IOException;
import java.util.Iterator;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.CacheEntryVersion;
import org.apache.ignite.cdc.TypeMapping;
import org.apache.ignite.dump.DumpEntry;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.jackson.IgniteObjectMapper;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.DumpConsumerKernalContextAware;

public class JsonDumpConsumer
implements DumpConsumerKernalContextAware {
    private IgniteObjectMapper mapper;

    public void start(GridKernalContext ctx) {
        this.mapper = new IgniteObjectMapper(ctx);
    }

    public void onMappings(Iterator<TypeMapping> mappings) {
    }

    public void onTypes(Iterator<BinaryType> types) {
    }

    public void onCacheConfigs(Iterator<StoredCacheData> caches) {
    }

    public void onPartition(int grp, int part, Iterator<DumpEntry> data) {
        data.forEachRemaining(entry -> {
            try {
                System.out.println(this.mapper.writeValueAsString(new PrintableDumpEntry((DumpEntry)entry)));
            }
            catch (IOException e) {
                throw new IgniteException((Throwable)e);
            }
        });
    }

    public void stop() {
    }

    public void start() {
    }

    private static class PrintableCacheEntryVersion {
        private final CacheEntryVersion v;

        public PrintableCacheEntryVersion(CacheEntryVersion v) {
            this.v = v;
        }

        public long getOrder() {
            return this.v.order();
        }

        public int getNodeOrder() {
            return this.v.nodeOrder();
        }

        public byte getClusterId() {
            return this.v.clusterId();
        }

        public int getTopologyVersion() {
            return this.v.topologyVersion();
        }

        public PrintableCacheEntryVersion otherClusterVersion() {
            return new PrintableCacheEntryVersion(this.v.otherClusterVersion());
        }
    }

    private static class PrintableDumpEntry {
        private final DumpEntry e;

        public PrintableDumpEntry(DumpEntry e) {
            this.e = e;
        }

        public int getCacheId() {
            return this.e.cacheId();
        }

        public long getExpireTime() {
            return this.e.expireTime();
        }

        public PrintableCacheEntryVersion getVersion() {
            return new PrintableCacheEntryVersion(this.e.version());
        }

        public Object getKey() {
            return this.e.key();
        }

        public Object getValue() {
            return this.e.value();
        }
    }
}

