/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.user;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.RestUserActionRequest;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class UserActionCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.ADD_USER, GridRestCommand.REMOVE_USER, GridRestCommand.UPDATE_USER);

    public UserActionCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) throws IgniteCheckedException {
        assert (req != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling topology REST request: " + req);
        }
        RestUserActionRequest req0 = (RestUserActionRequest)req;
        GridRestCommand cmd = req.command();
        IgniteSecurity security = this.ctx.security();
        switch (cmd) {
            case ADD_USER: {
                security.createUser(req0.user(), req0.password().toCharArray());
                break;
            }
            case REMOVE_USER: {
                security.dropUser(req0.user());
                break;
            }
            case UPDATE_USER: {
                security.alterUser(req0.user(), req0.password().toCharArray());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handled topology REST request [req=" + req + "]");
        }
        return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(true));
    }
}

