/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.table.TableBase;

public class H2TableEngine
implements TableEngine {
    private static GridH2RowDescriptor rowDesc0;
    private static H2TableDescriptor tblDesc0;
    private static GridH2Table resTbl0;
    private static IndexProcessor idxMgr0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized GridH2Table createTable(Connection conn, String sql, GridH2RowDescriptor rowDesc, H2TableDescriptor tblDesc, IndexProcessor idxMgr) throws SQLException {
        rowDesc0 = rowDesc;
        tblDesc0 = tblDesc;
        try {
            try (Statement s = conn.createStatement();){
                s.execute(sql + " engine \"" + H2TableEngine.class.getName() + "\"");
            }
            tblDesc.table(resTbl0);
            GridH2Table gridH2Table = resTbl0;
            return gridH2Table;
        }
        finally {
            resTbl0 = null;
            tblDesc0 = null;
            rowDesc0 = null;
        }
    }

    public TableBase createTable(CreateTableData createTblData) {
        resTbl0 = new GridH2Table(createTblData, rowDesc0, tblDesc0, tblDesc0.cacheInfo());
        return resTbl0;
    }
}

