/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.ExecutionNodeMemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.MemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.ObjectSizeCalculator;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.RowTracker;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.MultiStepPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlan;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class ListFieldsQueryCursor<Row>
implements FieldsQueryCursor<List<?>>,
QueryCursorEx<List<?>> {
    private final Iterator<List<?>> it;
    private final List<GridQueryFieldMetadata> fieldsMeta;
    private final MemoryTracker qryMemoryTracker;
    private final boolean isQry;

    public ListFieldsQueryCursor(MultiStepPlan plan, Iterator<List<?>> it, ExecutionContext<Row> ectx, MemoryTracker qryMemoryTracker) {
        FieldsMetadata metadata0 = plan.fieldsMetadata();
        assert (metadata0 != null);
        this.fieldsMeta = metadata0.queryFieldsMetadata(ectx.getTypeFactory());
        this.isQry = plan.type() == QueryPlan.Type.QUERY;
        this.qryMemoryTracker = qryMemoryTracker;
        this.it = it;
    }

    @NotNull
    public Iterator<List<?>> iterator() {
        return this.it;
    }

    public List<List<?>> getAll() {
        ArrayList res = new ArrayList();
        RowTracker rowTracker = ExecutionNodeMemoryTracker.create(this.qryMemoryTracker, ObjectSizeCalculator.OBJ_REF_SIZE);
        try {
            this.getAll(row -> {
                rowTracker.onRowAdded(row);
                res.add((List<?>)row);
            });
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
        finally {
            this.qryMemoryTracker.reset();
        }
        return res;
    }

    public void getAll(QueryCursorEx.Consumer<List<?>> c) throws IgniteCheckedException {
        try {
            while (this.it.hasNext()) {
                c.consume(this.it.next());
            }
        }
        finally {
            this.close();
        }
    }

    public List<GridQueryFieldMetadata> fieldsMeta() {
        return this.fieldsMeta;
    }

    public String getFieldName(int idx) {
        return this.fieldsMeta.get(idx).fieldName();
    }

    public int getColumnsCount() {
        return this.fieldsMeta.size();
    }

    public boolean isQuery() {
        return this.isQry;
    }

    public void close() {
        Commons.closeQuiet(this.it);
    }
}

