/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.jetbrains.annotations.Nullable;

public class IgniteMdColumnOrigins
implements MetadataHandler<BuiltInMetadata.ColumnOrigin> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.COLUMN_ORIGIN.method, (MetadataHandler)new IgniteMdColumnOrigins());

    public MetadataDef<BuiltInMetadata.ColumnOrigin> getDef() {
        return BuiltInMetadata.ColumnOrigin.DEF;
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(Aggregate rel, RelMetadataQuery mq, int iOutputColumn) {
        if (iOutputColumn < rel.getGroupCount()) {
            return mq.getColumnOrigins(rel.getInput(), ((Integer)rel.getGroupSet().asList().get(iOutputColumn)).intValue());
        }
        AggregateCall call = (AggregateCall)rel.getAggCallList().get(iOutputColumn - rel.getGroupCount());
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (Integer iInput : call.getArgList()) {
            Set<RelColumnOrigin> inputSet = mq.getColumnOrigins(rel.getInput(), iInput.intValue());
            if ((inputSet = IgniteMdColumnOrigins.createDerivedColumnOrigins(inputSet)) == null) continue;
            set.addAll(inputSet);
        }
        return set;
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(Join rel, RelMetadataQuery mq, int iOutputColumn) {
        Set<RelColumnOrigin> set;
        int nLeftColumns = rel.getLeft().getRowType().getFieldList().size();
        boolean derived = false;
        if (iOutputColumn < nLeftColumns) {
            set = mq.getColumnOrigins(rel.getLeft(), iOutputColumn);
            if (rel.getJoinType().generatesNullsOnLeft()) {
                derived = true;
            }
        } else {
            set = mq.getColumnOrigins(rel.getRight(), iOutputColumn - nLeftColumns);
            if (rel.getJoinType().generatesNullsOnRight()) {
                derived = true;
            }
        }
        if (derived) {
            set = IgniteMdColumnOrigins.createDerivedColumnOrigins(set);
        }
        return set;
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(SetOp rel, RelMetadataQuery mq, int iOutputColumn) {
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelNode input : rel.getInputs()) {
            Set inputSet = mq.getColumnOrigins(input, iOutputColumn);
            if (inputSet == null) {
                return null;
            }
            set.addAll(inputSet);
        }
        return set;
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(Project rel, RelMetadataQuery mq, int iOutputColumn) {
        RelNode input = rel.getInput();
        RexNode rexNode = (RexNode)rel.getProjects().get(iOutputColumn);
        if (rexNode instanceof RexInputRef) {
            RexInputRef inputRef = (RexInputRef)rexNode;
            return mq.getColumnOrigins(input, inputRef.getIndex());
        }
        Set<RelColumnOrigin> set = IgniteMdColumnOrigins.getMultipleColumns(rexNode, input, mq);
        return IgniteMdColumnOrigins.createDerivedColumnOrigins(set);
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(final Calc rel, RelMetadataQuery mq, int iOutputColumn) {
        RelNode input = rel.getInput();
        RexShuttle rexShuttle = new RexShuttle(){

            public RexNode visitLocalRef(RexLocalRef localRef) {
                return rel.getProgram().expandLocalRef(localRef);
            }
        };
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (RexNode rex : rexShuttle.apply(rel.getProgram().getProjectList())) {
            projects.add(rex);
        }
        RexNode rexNode = (RexNode)projects.get(iOutputColumn);
        if (rexNode instanceof RexInputRef) {
            RexInputRef inputRef = (RexInputRef)rexNode;
            return mq.getColumnOrigins(input, inputRef.getIndex());
        }
        Set<RelColumnOrigin> set = IgniteMdColumnOrigins.getMultipleColumns(rexNode, input, mq);
        return IgniteMdColumnOrigins.createDerivedColumnOrigins(set);
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(Filter rel, RelMetadataQuery mq, int iOutputColumn) {
        return mq.getColumnOrigins(rel.getInput(), iOutputColumn);
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(Sort rel, RelMetadataQuery mq, int iOutputColumn) {
        return mq.getColumnOrigins(rel.getInput(), iOutputColumn);
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(TableModify rel, RelMetadataQuery mq, int iOutputColumn) {
        return mq.getColumnOrigins(rel.getInput(), iOutputColumn);
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(Exchange rel, RelMetadataQuery mq, int iOutputColumn) {
        return mq.getColumnOrigins(rel.getInput(), iOutputColumn);
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(TableFunctionScan rel, RelMetadataQuery mq, int iOutputColumn) {
        Set mappings = rel.getColumnMappings();
        if (mappings == null) {
            if (!rel.getInputs().isEmpty()) {
                return null;
            }
            return Collections.emptySet();
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelColumnMapping mapping : mappings) {
            int column;
            if (mapping.iOutputColumn != iOutputColumn) continue;
            RelNode input = (RelNode)rel.getInputs().get(mapping.iInputRel);
            Set<RelColumnOrigin> origins = mq.getColumnOrigins(input, column = mapping.iInputColumn);
            if (origins == null) {
                return null;
            }
            if (mapping.derived) {
                origins = IgniteMdColumnOrigins.createDerivedColumnOrigins(origins);
            }
            set.addAll(origins);
        }
        return set;
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(ProjectableFilterableTableScan rel, RelMetadataQuery mq, int iOutputColumn) {
        if (rel.projects() != null) {
            RexNode proj = rel.projects().get(iOutputColumn);
            HashSet sources = new HashSet();
            this.getOperands(proj, RexSlot.class, sources);
            boolean derived = sources.size() > 1;
            HashSet<RelColumnOrigin> res = new HashSet<RelColumnOrigin>();
            for (RexSlot slot : sources) {
                if (!(slot instanceof RexLocalRef)) continue;
                RelColumnOrigin slotOrigin = rel.columnOriginsByRelLocalRef(slot.getIndex());
                res.add(new RelColumnOrigin(slotOrigin.getOriginTable(), slotOrigin.getOriginColumnOrdinal(), derived));
            }
            return res;
        }
        return Collections.singleton(rel.columnOriginsByRelLocalRef(iOutputColumn));
    }

    private <T> void getOperands(RexNode rn, Class<T> cls, Set<T> res) {
        if (cls.isAssignableFrom(rn.getClass())) {
            res.add(rn);
        }
        if (rn instanceof RexCall) {
            List operands = ((RexCall)rn).getOperands();
            for (RexNode op : operands) {
                this.getOperands(op, cls, res);
            }
        }
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(RelNode rel, RelMetadataQuery mq, int iOutputColumn) {
        if (!rel.getInputs().isEmpty()) {
            return null;
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        RelOptTable table = rel.getTable();
        if (table == null) {
            return set;
        }
        if (table.getRowType() != rel.getRowType()) {
            return null;
        }
        set.add(new RelColumnOrigin(table, iOutputColumn, false));
        return set;
    }

    private static Set<RelColumnOrigin> createDerivedColumnOrigins(Set<RelColumnOrigin> inputSet) {
        if (inputSet == null) {
            return null;
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelColumnOrigin rco : inputSet) {
            RelColumnOrigin derived = new RelColumnOrigin(rco.getOriginTable(), rco.getOriginColumnOrdinal(), true);
            set.add(derived);
        }
        return set;
    }

    private static Set<RelColumnOrigin> getMultipleColumns(RexNode rexNode, final RelNode input, final RelMetadataQuery mq) {
        final HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            public Void visitInputRef(RexInputRef inputRef) {
                Set inputSet = mq.getColumnOrigins(input, inputRef.getIndex());
                if (inputSet != null) {
                    set.addAll(inputSet);
                }
                return null;
            }
        };
        rexNode.accept((RexVisitor)visitor);
        return set;
    }
}

