/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.impl.BenchmarkProbeSet;

public class BenchmarkRunner {
    public static final String INTERVAL = "BENCHMARK_BUILD_PROBE_POINT_INTERVAL";
    public static final long DEFAULT_INTERVAL_IN_MSECS = 1000L;
    private final BenchmarkConfiguration cfg;
    private final BenchmarkDriver[] drivers;
    private volatile boolean cancelled;
    private ShutdownThread shutdownThread;
    private volatile Collection<Thread> threads;
    private final BenchmarkProbeSet[] probeSets;
    private final int[] weights;
    private volatile Throwable err;
    private Thread buildingThread;

    public BenchmarkRunner(BenchmarkConfiguration cfg, BenchmarkDriver[] drivers, BenchmarkProbeSet[] probeSets, int[] weights) {
        this.cfg = cfg;
        this.drivers = drivers;
        this.probeSets = probeSets;
        this.weights = weights;
    }

    public synchronized void runBenchmark() throws Exception {
        final int threadNum = this.cfg.threads();
        this.threads = new ArrayList<Thread>(threadNum);
        final AtomicInteger finished = new AtomicInteger(0);
        for (BenchmarkProbeSet probeSet : this.probeSets) {
            probeSet.start();
        }
        this.startBuildingThread();
        BenchmarkUtils.println("Starting warmup.");
        final long testStart = System.currentTimeMillis();
        final long totalDuration = this.cfg.duration() + this.cfg.warmup();
        final int sumWeight = this.sumWeights();
        final Phaser phaser = new Phaser(threadNum){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                for (BenchmarkDriver drv : BenchmarkRunner.this.drivers) {
                    drv.onWarmupFinished();
                }
                for (BenchmarkProbeSet set : BenchmarkRunner.this.probeSets) {
                    set.onWarmupFinished();
                }
                BenchmarkUtils.println("Starting main test (warmup finished).");
                return true;
            }
        };
        final AtomicLong opsCnt = new AtomicLong();
        for (int i = 0; i < threadNum; ++i) {
            final int threadIdx = i;
            final int logFreq = this.cfg.logIterationsFrequency();
            this.threads.add(new Thread(new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    drv = null;
                    try {
                        rand = new Random();
                        ctx = new HashMap<Object, Object>();
                        if (BenchmarkRunner.access$200(BenchmarkRunner.this).warmup() > 0L) {
                            reset = true;
                        } else {
                            reset = false;
                            phaser.arriveAndAwaitAdvance();
                        }
                        while (!BenchmarkRunner.access$300(BenchmarkRunner.this) && !Thread.currentThread().isInterrupted()) {
                            if (reset) ** GOTO lbl-1000
                            ops = opsCnt.incrementAndGet();
                            if (ops % (long)logFreq == 0L) {
                                BenchmarkUtils.println("Starting iteration: " + ops);
                            }
                            if (BenchmarkRunner.access$200(BenchmarkRunner.this).operationsCount() > 0 && ops > (long)BenchmarkRunner.access$200(BenchmarkRunner.this).operationsCount()) {
                                for (BenchmarkProbeSet set : BenchmarkRunner.access$100(BenchmarkRunner.this)) {
                                    set.onFinished();
                                }
                            } else lbl-1000:
                            // 2 sources

                            {
                                idx = BenchmarkRunner.access$400(BenchmarkRunner.this, rand, sumWeight);
                                drv = BenchmarkRunner.access$000(BenchmarkRunner.this)[idx];
                                probeSet = BenchmarkRunner.access$100(BenchmarkRunner.this)[idx];
                                probeSet.onBeforeExecute(threadIdx);
                                res = drv.test(ctx);
                                probeSet.onAfterExecute(threadIdx);
                                if (!res) {
                                    for (BenchmarkProbeSet set : BenchmarkRunner.access$100(BenchmarkRunner.this)) {
                                        set.onFinished();
                                    }
                                } else {
                                    now = System.currentTimeMillis();
                                    elapsed = (now - testStart) / 1000L;
                                    if (reset && elapsed > BenchmarkRunner.access$200(BenchmarkRunner.this).warmup()) {
                                        phaser.arriveAndAwaitAdvance();
                                        reset = false;
                                        continue;
                                    }
                                    if (reset || BenchmarkRunner.access$200(BenchmarkRunner.this).operationsCount() != 0 || elapsed <= totalDuration) continue;
                                    for (BenchmarkProbeSet set : BenchmarkRunner.access$100(BenchmarkRunner.this)) {
                                        set.onFinished();
                                    }
                                }
                            }
                            break;
                        }
                        if (finished.incrementAndGet() == threadNum) {
                            BenchmarkRunner.access$500(BenchmarkRunner.this);
                        }
                    }
                    catch (Throwable e) {
                        try {
                            if (drv != null) {
                                drv.onException(e);
                            }
                        }
                        catch (Throwable var3_5) {
                            // empty catch block
                        }
                        phaser.forceTermination();
                        BenchmarkRunner.access$600(BenchmarkRunner.this, e);
                    }
                }
            }, "benchmark-worker-" + i));
        }
        for (Thread t : this.threads) {
            t.start();
        }
    }

    private void startBuildingThread() {
        final long interval = BenchmarkRunner.interval(this.cfg);
        this.buildingThread = new Thread(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        long time = System.currentTimeMillis();
                        for (BenchmarkProbeSet probeSet : BenchmarkRunner.this.probeSets) {
                            probeSet.buildPoint(time);
                        }
                        Thread.sleep(interval);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.buildingThread.start();
    }

    private int driverIndex(Random rand, int sumWeight) throws Exception {
        int len = this.weights.length;
        if (len == 1) {
            return 0;
        }
        int w = rand.nextInt(sumWeight);
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            if ((sum += this.weights[i]) <= w) continue;
            return i;
        }
        throw new Exception("Can not reach here.");
    }

    private int sumWeights() {
        int sumWeight = 0;
        for (int w : this.weights) {
            sumWeight += w;
        }
        return sumWeight;
    }

    public void cancel() {
        this.cancel(null);
    }

    private synchronized void cancel(Throwable e) {
        if (!this.cancelled) {
            this.err = e;
            this.cancelled = true;
            this.shutdown();
        }
    }

    private synchronized void shutdown() {
        if (this.shutdownThread == null) {
            long now = System.currentTimeMillis();
            System.out.println("Finishing main test [ts=" + now + ", date=" + new Date(now) + ']');
            this.shutdownThread = new ShutdownThread();
            this.shutdownThread.start();
        }
    }

    private static long interval(BenchmarkConfiguration cfg) {
        try {
            return Long.parseLong(cfg.customProperties().get(INTERVAL));
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return 1000L;
        }
    }

    static /* synthetic */ boolean access$300(BenchmarkRunner x0) {
        return x0.cancelled;
    }

    static /* synthetic */ int access$400(BenchmarkRunner x0, Random x1, int x2) throws Exception {
        return x0.driverIndex(x1, x2);
    }

    static /* synthetic */ void access$500(BenchmarkRunner x0) {
        x0.shutdown();
    }

    static /* synthetic */ void access$600(BenchmarkRunner x0, Throwable x1) {
        x0.cancel(x1);
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            if (BenchmarkRunner.this.err != null) {
                BenchmarkUtils.errorHelp(BenchmarkRunner.this.cfg, "Shutting down benchmark driver to unexpected exception.", BenchmarkRunner.this.err);
            }
            try {
                if (BenchmarkRunner.this.buildingThread != null) {
                    BenchmarkRunner.this.buildingThread.interrupt();
                    BenchmarkRunner.this.buildingThread.join();
                }
                for (Thread t : BenchmarkRunner.this.threads) {
                    t.join();
                }
                for (int i = 0; i < BenchmarkRunner.this.drivers.length; ++i) {
                    try {
                        BenchmarkRunner.this.drivers[i].tearDown();
                    }
                    catch (Exception e) {
                        BenchmarkUtils.errorHelp(BenchmarkRunner.this.cfg, "Failed to gracefully stop driver [driver=" + BenchmarkRunner.this.drivers[i] + ", err=" + e.getMessage() + ']', e);
                    }
                    try {
                        BenchmarkRunner.this.probeSets[i].stop();
                        continue;
                    }
                    catch (Exception e) {
                        BenchmarkUtils.errorHelp(BenchmarkRunner.this.cfg, "Failed to gracefully stop probe set [probe=" + BenchmarkRunner.this.probeSets[i] + ", err=" + e.getMessage() + ']', e);
                    }
                }
            }
            catch (Exception e) {
                BenchmarkUtils.errorHelp(BenchmarkRunner.this.cfg, "Failed to gracefully shutdown benchmark runner.", e);
            }
        }
    }
}

