/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.cache.IgnitePutAllBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public class IgnitePutAllMultiCacheTxBenchmark
extends IgnitePutAllBenchmark {
    private Consumer<Map<Integer, Integer>> cons;
    private IgniteTransactions txs;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.txs = this.ignite().transactions();
        if (this.cachesCnt() <= 1) {
            throw new IllegalArgumentException("Please configure --cachesCnt param, need to be more that 1.");
        }
        for (IgniteCache cache : this.testCaches) {
            if (((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL) continue;
            throw new IllegalArgumentException("Only transactional caches need to be present.");
        }
        this.cons = vals -> {
            for (IgniteCache cache : this.testCaches) {
                cache.putAll(vals);
            }
        };
    }

    @Override
    protected void putData(Map<Integer, Integer> vals) throws Exception {
        IgniteBenchmarkUtils.doInTransaction(this.txs, this.args.txConcurrency(), this.args.txIsolation(), () -> {
            this.cons.accept(vals);
            return null;
        });
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("tx");
    }
}

