/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import org.jline.reader.Candidate;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.utils.AttributedString;

public class ClassNameCompleter
extends StringsCompleter {
    public ClassNameCompleter() throws IOException {
        super(ClassNameCompleter.getClassNames());
        this.candidates.add(new Candidate(AttributedString.stripAnsi((String)"."), ".", null, null, null, null, true));
    }

    public static Set<String> getClassNames() throws IOException {
        Class[] systemClasses;
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader loader = ClassNameCompleter.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            Collections.addAll(urls, ((URLClassLoader)loader).getURLs());
        }
        for (Class systemClass : systemClasses = new Class[]{String.class, JFrame.class}) {
            URLConnection uc;
            URL classURL = systemClass.getResource("/" + systemClass.getName().replace('.', '/') + ".class");
            if (classURL == null || !((uc = classURL.openConnection()) instanceof JarURLConnection)) continue;
            urls.add(((JarURLConnection)uc).getJarFileURL());
        }
        HashSet<String> classes = new HashSet<String>();
        for (URL url : urls) {
            File file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            if (file.isDirectory()) {
                Set<String> files = ClassNameCompleter.getClassFiles(file.getAbsolutePath(), new HashSet<String>(), file, new int[]{200});
                classes.addAll(files);
                continue;
            }
            if (!file.isFile() || !file.toString().endsWith(".jar")) continue;
            JarFile jf = new JarFile(file);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                String name;
                JarEntry entry = e.nextElement();
                if (entry == null || !(name = entry.getName()).endsWith(".class")) continue;
                classes.add(name);
            }
        }
        TreeSet<String> classNames = new TreeSet<String>();
        for (String name : classes) {
            classNames.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return classNames;
    }

    private static Set<String> getClassFiles(String root, Set<String> holder, File directory, int[] maxDirectories) {
        int n = maxDirectories[0];
        maxDirectories[0] = n - 1;
        if (n < 0) {
            return holder;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return holder;
        }
        for (File file : files) {
            String name = file.getAbsolutePath();
            if (!name.startsWith(root)) continue;
            if (file.isDirectory()) {
                ClassNameCompleter.getClassFiles(root, holder, file, maxDirectories);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            holder.add(file.getAbsolutePath().substring(root.length() + 1));
        }
        return holder;
    }
}

