/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;

abstract class ZkDiscoveryEventData
implements Serializable {
    static final byte ZK_EVT_NODE_JOIN = 1;
    static final byte ZK_EVT_NODE_LEFT = 2;
    static final byte ZK_EVT_CUSTOM_EVT = 3;
    private static final long serialVersionUID = 0L;
    private final long evtId;
    private final byte evtType;
    private final long topVer;
    private transient Set<Long> remainingAcks;
    int flags;

    ZkDiscoveryEventData(long evtId, byte evtType, long topVer) {
        assert (evtType == 1 || evtType == 2 || evtType == 3) : evtType;
        this.evtId = evtId;
        this.evtType = evtType;
        this.topVer = topVer;
    }

    void initRemainingAcks(Collection<ZookeeperClusterNode> nodes) {
        assert (this.remainingAcks == null) : this;
        this.remainingAcks = U.newHashSet((int)nodes.size());
        for (ZookeeperClusterNode node : nodes) {
            if (node.isLocal() || node.order() > this.topVer) continue;
            boolean add = this.remainingAcks.add(node.internalId());
            assert (add) : node;
        }
    }

    void addRemainingAck(ZookeeperClusterNode node) {
        assert (node.order() <= this.topVer) : node;
        boolean add = this.remainingAcks.add(node.internalId());
        assert (add) : node;
    }

    boolean allAcksReceived() {
        return this.remainingAcks.isEmpty();
    }

    Set<Long> remainingAcks() {
        return this.remainingAcks;
    }

    boolean onAckReceived(Long nodeInternalId, long ackEvtId) {
        assert (this.remainingAcks != null);
        if (ackEvtId >= this.evtId) {
            this.remainingAcks.remove(nodeInternalId);
        }
        return this.remainingAcks.isEmpty();
    }

    boolean onNodeFail(ZookeeperClusterNode node) {
        assert (this.remainingAcks != null) : this;
        this.remainingAcks.remove(node.internalId());
        return this.remainingAcks.isEmpty();
    }

    boolean flagSet(int flag) {
        return (this.flags & flag) == flag;
    }

    long eventId() {
        return this.evtId;
    }

    byte eventType() {
        return this.evtType;
    }

    long topologyVersion() {
        return this.topVer;
    }
}

