/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestByteArrayEntity {
    TestByteArrayEntity() {
    }

    @Test
    void testBasics() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        try (ByteArrayEntity entity = new ByteArrayEntity(bytes, null);){
            Assertions.assertEquals((long)bytes.length, (long)entity.getContentLength());
            Assertions.assertNotNull((Object)entity.getContent());
            Assertions.assertTrue((boolean)entity.isRepeatable());
            Assertions.assertFalse((boolean)entity.isStreaming());
        }
    }

    @Test
    void testBasicOffLen() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        try (ByteArrayEntity entity = new ByteArrayEntity(bytes, 8, 7, null);){
            Assertions.assertEquals((long)7L, (long)entity.getContentLength());
            Assertions.assertNotNull((Object)entity.getContent());
            Assertions.assertTrue((boolean)entity.isRepeatable());
            Assertions.assertFalse((boolean)entity.isStreaming());
        }
    }

    @Test
    void testIllegalConstructorNullByteArray() {
        Assertions.assertThrows(NullPointerException.class, () -> new ByteArrayEntity(null, null));
    }

    @Test
    void testIllegalConstructorBadLen() {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteArrayEntity(bytes, 0, bytes.length + 1, null));
    }

    @Test
    void testIllegalConstructorBadOff1() {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteArrayEntity(bytes, -1, bytes.length, null));
    }

    @Test
    void testIllegalConstructorBadOff2() {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteArrayEntity(bytes, bytes.length + 1, bytes.length, null));
    }

    @Test
    void testWriteTo() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        try (ByteArrayEntity entity = new ByteArrayEntity(bytes, null);){
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)out);
            byte[] bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            out = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)out);
            bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            Assertions.assertThrows(NullPointerException.class, () -> entity.writeTo(null));
        }
    }

    @Test
    void testWriteToOffLen() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        int off = 8;
        int len = 7;
        try (ByteArrayEntity entity = new ByteArrayEntity(bytes, 8, 7, null);){
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)out);
            byte[] bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)7, (int)bytes2.length);
            for (i = 0; i < 7; ++i) {
                Assertions.assertEquals((byte)bytes[i + 8], (byte)bytes2[i]);
            }
            out = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)out);
            bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)7, (int)bytes2.length);
            for (i = 0; i < 7; ++i) {
                Assertions.assertEquals((byte)bytes[i + 8], (byte)bytes2[i]);
            }
            Assertions.assertThrows(NullPointerException.class, () -> entity.writeTo(null));
        }
    }
}

