/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import org.apache.hc.core5.util.Asserts;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAsserts {
    TestAsserts() {
    }

    @Test
    void testExpressionCheckPass() {
        Asserts.check((boolean)true, (String)"All is well");
    }

    @Test
    void testExpressionCheckFail() {
        Assertions.assertThrows(IllegalStateException.class, () -> Asserts.check((boolean)false, (String)"Oopsie"));
    }

    @Test
    void testExpressionNotNullFail() {
        Assertions.assertThrows(IllegalStateException.class, () -> Asserts.notNull(null, (String)"Stuff"));
    }

    @Test
    void testExpressionNotEmptyFail1() {
        Assertions.assertThrows(IllegalStateException.class, () -> Asserts.notEmpty(null, (String)"Stuff"));
    }

    @Test
    void testExpressionNotEmptyFail2() {
        Assertions.assertThrows(IllegalStateException.class, () -> Asserts.notEmpty((CharSequence)"", (String)"Stuff"));
    }

    @Test
    void testExpressionNotEmptyBlank1() {
        Assertions.assertThrows(IllegalStateException.class, () -> Asserts.notBlank(null, (String)"Stuff"));
    }

    @Test
    void testExpressionNotEmptyBlank2() {
        Assertions.assertThrows(IllegalStateException.class, () -> Asserts.notBlank((CharSequence)"", (String)"Stuff"));
    }

    @Test
    void testExpressionNotBlankFail3() {
        Assertions.assertThrows(IllegalStateException.class, () -> Asserts.notBlank((CharSequence)" \t \n\r", (String)"Stuff"));
    }
}

