/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.Objects;

public final class ObservableMapNotification<T, R>
extends AbstractObservableWithUpstream<T, ObservableSource<? extends R>> {
    final Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper;
    final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorMapper;
    final Supplier<? extends ObservableSource<? extends R>> onCompleteSupplier;

    public ObservableMapNotification(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorMapper, Supplier<? extends ObservableSource<? extends R>> onCompleteSupplier) {
        super(source);
        this.onNextMapper = onNextMapper;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteSupplier = onCompleteSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super ObservableSource<? extends R>> t) {
        this.source.subscribe(new MapNotificationObserver(t, this.onNextMapper, this.onErrorMapper, this.onCompleteSupplier));
    }

    static final class MapNotificationObserver<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super ObservableSource<? extends R>> downstream;
        final Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper;
        final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorMapper;
        final Supplier<? extends ObservableSource<? extends R>> onCompleteSupplier;
        Disposable upstream;

        MapNotificationObserver(Observer<? super ObservableSource<? extends R>> actual, Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorMapper, Supplier<? extends ObservableSource<? extends R>> onCompleteSupplier) {
            this.downstream = actual;
            this.onNextMapper = onNextMapper;
            this.onErrorMapper = onErrorMapper;
            this.onCompleteSupplier = onCompleteSupplier;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            ObservableSource<? extends R> p;
            try {
                p = Objects.requireNonNull(this.onNextMapper.apply(t), "The onNext ObservableSource returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(e);
                return;
            }
            this.downstream.onNext(p);
        }

        @Override
        public void onError(Throwable t) {
            ObservableSource<? extends R> p;
            try {
                p = Objects.requireNonNull(this.onErrorMapper.apply(t), "The onError ObservableSource returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t, e));
                return;
            }
            this.downstream.onNext(p);
            this.downstream.onComplete();
        }

        @Override
        public void onComplete() {
            ObservableSource<? extends R> p;
            try {
                p = Objects.requireNonNull(this.onCompleteSupplier.get(), "The onComplete ObservableSource returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(e);
                return;
            }
            this.downstream.onNext(p);
            this.downstream.onComplete();
        }
    }
}

