/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.List;

@InternalApi(value="For internal use only")
public class ReadRowsBatchingDescriptor
implements BatchingDescriptor<ByteString, Row, Query, List<Row>> {
    public BatchingRequestBuilder<ByteString, Query> newRequestBuilder(Query query) {
        return new BulkReadRequestBuilder(query);
    }

    public void splitResponse(List<Row> rowsResponse, List<BatchEntry<ByteString, Row>> entries) {
        HashMap<ByteString, Row> rowKeys = new HashMap<ByteString, Row>();
        for (Row row : rowsResponse) {
            rowKeys.put(row.getKey(), row);
        }
        for (BatchEntry batchEntry : entries) {
            batchEntry.getResultFuture().set(rowKeys.get(batchEntry.getElement()));
        }
    }

    public void splitException(Throwable throwable, List<BatchEntry<ByteString, Row>> entries) {
        for (BatchEntry<ByteString, Row> resultEntry : entries) {
            resultEntry.getResultFuture().setException(throwable);
        }
    }

    public long countBytes(ByteString bytes) {
        return bytes.size();
    }

    static class BulkReadRequestBuilder
    implements BatchingRequestBuilder<ByteString, Query> {
        private final Query query;

        BulkReadRequestBuilder(Query query) {
            this.query = query.clone();
        }

        public void add(ByteString rowKey) {
            this.query.rowKey(rowKey);
        }

        public Query build() {
            return this.query;
        }
    }
}

