/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EnterPrintDialog
extends Dialog {
    private static final Class<?> PKG = EnterPrintDialog.class;
    private int retval;
    private Image image;
    private Canvas wCanvas;
    private Slider wCols;
    private Slider wRows;
    private Slider wScale;
    private Text wLeft;
    private Text wRight;
    private Text wTop;
    private Text wBottom;
    private Shell shell;
    private PropsUi props = PropsUi.getInstance();
    public int nrcols;
    public int nrrows;
    public int scale;
    public Point page;
    public double factorx;
    public double factory;
    public double leftMargin;
    public double rightMargin;
    public double topMargin;
    public double bottomMargin;

    public EnterPrintDialog(Shell parent, int nrcols, int nrrows, int scale, double factorX, double factorY, Rectangle m, double marginLeft, double marginRigth, double marginTop, double marginBottom, Image image) {
        super(parent, 0);
        this.nrcols = nrcols;
        this.nrrows = nrrows;
        this.scale = scale;
        this.image = image;
        this.factorx = factorX;
        this.factory = factorY;
        this.leftMargin = marginLeft;
        this.rightMargin = marginRigth;
        this.topMargin = marginTop;
        this.bottomMargin = marginBottom;
        this.page = new Point(m.width, m.height);
    }

    public int open() {
        Shell parent = this.getParent();
        this.retval = 32;
        this.shell = new Shell(parent, 268504304);
        PropsUi.setLook((Widget)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        EnterPrintDialog enterPrintDialog = this;
        int margin = enterPrintDialog.props.getMargin();
        Label wlCanvas = new Label((Composite)this.shell, 0);
        wlCanvas.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.PrintArea.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCanvas);
        FormData fdlCanvas = new FormData();
        fdlCanvas.left = new FormAttachment(0, 0);
        fdlCanvas.top = new FormAttachment(0, margin);
        wlCanvas.setLayoutData((Object)fdlCanvas);
        this.wCanvas = new Canvas((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wCanvas);
        this.wCanvas.addPaintListener(pe -> this.repaint(pe.gc, pe.width, pe.height));
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.top = new FormAttachment((Control)wlCanvas, margin);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.bottom = new FormAttachment(100, -220);
        this.wCanvas.setLayoutData((Object)fdCanvas);
        Label wlRows = new Label((Composite)this.shell, 0);
        wlRows.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.Rows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRows);
        FormData fdlRows = new FormData();
        fdlRows.left = new FormAttachment(0, 0);
        fdlRows.right = new FormAttachment(middle, -margin);
        fdlRows.top = new FormAttachment((Control)this.wCanvas, margin);
        wlRows.setLayoutData((Object)fdlRows);
        this.wRows = new Slider((Composite)this.shell, 256);
        this.wRows.setIncrement(1);
        this.wRows.setMinimum(1);
        this.wRows.setMaximum(11);
        this.wRows.setThumb(1);
        this.wRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Slider sl = (Slider)se.widget;
                EnterPrintDialog.this.nrrows = sl.getSelection();
                EnterPrintDialog.this.wCanvas.redraw();
            }
        });
        PropsUi.setLook((Widget)this.wRows);
        FormData fdRows = new FormData();
        fdRows.left = new FormAttachment(middle, 0);
        fdRows.top = new FormAttachment((Control)this.wCanvas, margin);
        fdRows.right = new FormAttachment(100, 0);
        this.wRows.setLayoutData((Object)fdRows);
        Label wlCols = new Label((Composite)this.shell, 0);
        wlCols.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.Cols.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCols);
        FormData fdlCols = new FormData();
        fdlCols.left = new FormAttachment(0, 0);
        fdlCols.right = new FormAttachment(middle, -margin);
        fdlCols.top = new FormAttachment((Control)this.wRows, margin);
        wlCols.setLayoutData((Object)fdlCols);
        this.wCols = new Slider((Composite)this.shell, 256);
        this.wCols.setIncrement(1);
        this.wCols.setMinimum(1);
        this.wCols.setMaximum(11);
        this.wCols.setThumb(1);
        this.wCols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Slider sl = (Slider)se.widget;
                EnterPrintDialog.this.nrcols = sl.getSelection();
                EnterPrintDialog.this.wCanvas.redraw();
            }
        });
        PropsUi.setLook((Widget)this.wCols);
        FormData fdCols = new FormData();
        fdCols.left = new FormAttachment(middle, 0);
        fdCols.top = new FormAttachment((Control)this.wRows, margin);
        fdCols.right = new FormAttachment(100, 0);
        this.wCols.setLayoutData((Object)fdCols);
        Label wlScale = new Label((Composite)this.shell, 0);
        wlScale.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.Scaling.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScale);
        FormData fdlScale = new FormData();
        fdlScale.left = new FormAttachment(0, 0);
        fdlScale.right = new FormAttachment(middle, -margin);
        fdlScale.top = new FormAttachment((Control)this.wCols, margin);
        wlScale.setLayoutData((Object)fdlScale);
        this.wScale = new Slider((Composite)this.shell, 256);
        this.wScale.setIncrement(10);
        this.wScale.setMinimum(10);
        this.wScale.setMaximum(500);
        this.wScale.setThumb(10);
        this.wScale.setPageIncrement(25);
        this.wScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Slider sl = (Slider)se.widget;
                EnterPrintDialog.this.scale = sl.getSelection();
                EnterPrintDialog.this.wCanvas.redraw();
            }
        });
        PropsUi.setLook((Widget)this.wScale);
        FormData fdScale = new FormData();
        fdScale.left = new FormAttachment(middle, 0);
        fdScale.top = new FormAttachment((Control)this.wCols, margin);
        fdScale.right = new FormAttachment(100, 0);
        this.wScale.setLayoutData((Object)fdScale);
        Label wlLeft = new Label((Composite)this.shell, 0);
        wlLeft.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.LeftMargin.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLeft);
        FormData fdlLeft = new FormData();
        fdlLeft.left = new FormAttachment(0, 0);
        fdlLeft.right = new FormAttachment(middle, -margin);
        fdlLeft.top = new FormAttachment((Control)this.wScale, margin);
        wlLeft.setLayoutData((Object)fdlLeft);
        this.wLeft = new Text((Composite)this.shell, 2048);
        this.wLeft.addModifyListener(e -> {
            Text w = (Text)e.widget;
            this.leftMargin = Const.toDouble((String)w.getText(), (double)0.0);
        });
        PropsUi.setLook((Widget)this.wLeft);
        FormData fdLeft = new FormData();
        fdLeft.left = new FormAttachment(middle, 0);
        fdLeft.top = new FormAttachment((Control)this.wScale, margin);
        fdLeft.right = new FormAttachment(100, 0);
        this.wLeft.setLayoutData((Object)fdLeft);
        Label wlRight = new Label((Composite)this.shell, 0);
        wlRight.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.RightMargin.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRight);
        FormData fdlRight = new FormData();
        fdlRight.left = new FormAttachment(0, 0);
        fdlRight.right = new FormAttachment(middle, -margin);
        fdlRight.top = new FormAttachment((Control)this.wLeft, margin);
        wlRight.setLayoutData((Object)fdlRight);
        this.wRight = new Text((Composite)this.shell, 2048);
        this.wRight.addModifyListener(e -> {
            Text w = (Text)e.widget;
            this.rightMargin = Const.toDouble((String)w.getText(), (double)0.0);
        });
        PropsUi.setLook((Widget)this.wRight);
        FormData fdRight = new FormData();
        fdRight.left = new FormAttachment(middle, 0);
        fdRight.top = new FormAttachment((Control)this.wLeft, margin);
        fdRight.right = new FormAttachment(100, 0);
        this.wRight.setLayoutData((Object)fdRight);
        Label wlTop = new Label((Composite)this.shell, 0);
        wlTop.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.TopMargin.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTop);
        FormData fdlTop = new FormData();
        fdlTop.left = new FormAttachment(0, 0);
        fdlTop.right = new FormAttachment(middle, -margin);
        fdlTop.top = new FormAttachment((Control)this.wRight, margin);
        wlTop.setLayoutData((Object)fdlTop);
        this.wTop = new Text((Composite)this.shell, 2048);
        this.wTop.addModifyListener(e -> {
            Text w = (Text)e.widget;
            this.topMargin = Const.toDouble((String)w.getText(), (double)0.0);
        });
        PropsUi.setLook((Widget)this.wTop);
        FormData fdTop = new FormData();
        fdTop.left = new FormAttachment(middle, 0);
        fdTop.top = new FormAttachment((Control)this.wRight, margin);
        fdTop.right = new FormAttachment(100, 0);
        this.wTop.setLayoutData((Object)fdTop);
        Label wlBottom = new Label((Composite)this.shell, 0);
        wlBottom.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.BottomMargin.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBottom);
        FormData fdlBottom = new FormData();
        fdlBottom.left = new FormAttachment(0, 0);
        fdlBottom.right = new FormAttachment(middle, -margin);
        fdlBottom.top = new FormAttachment((Control)this.wTop, margin);
        wlBottom.setLayoutData((Object)fdlBottom);
        this.wBottom = new Text((Composite)this.shell, 2048);
        this.wBottom.addModifyListener(e -> {
            Text w = (Text)e.widget;
            this.bottomMargin = Const.toDouble((String)w.getText(), (double)0.0);
        });
        PropsUi.setLook((Widget)this.wBottom);
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(middle, 0);
        fdBottom.top = new FormAttachment((Control)this.wTop, margin);
        fdBottom.right = new FormAttachment(100, 0);
        this.wBottom.setLayoutData((Object)fdBottom);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.left = new FormAttachment(33, 0);
        fdOk.bottom = new FormAttachment(100, 0);
        wOk.setLayoutData((Object)fdOk);
        FormData fdCancel = new FormData();
        fdCancel.left = new FormAttachment(66, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        wCancel.setLayoutData((Object)fdCancel);
        wOk.addListener(13, e -> this.ok());
        wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.retval;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wCols.setSelection(this.nrcols);
        this.wRows.setSelection(this.nrrows);
        this.wScale.setSelection(this.scale);
        this.wLeft.setText(Double.toString(this.leftMargin));
        this.wRight.setText(Double.toString(this.rightMargin));
        this.wTop.setText(Double.toString(this.topMargin));
        this.wBottom.setText(Double.toString(this.bottomMargin));
    }

    private void cancel() {
        this.retval = 256;
        this.dispose();
    }

    private void ok() {
        this.nrcols = this.wCols.getSelection();
        this.nrrows = this.wRows.getSelection();
        this.scale = this.wScale.getSelection();
        this.dispose();
    }

    private void repaint(GC gc, int width, int height) {
        ImageData imd = this.image.getImageData();
        double sizeOnPaperX = (double)imd.width * this.factorx;
        double sizeOnPaperY = (double)imd.height * this.factory;
        double actualSizeX = sizeOnPaperX * (double)this.scale / 100.0;
        double actualSizeY = sizeOnPaperY * (double)this.scale / 100.0;
        double percentScreenX = actualSizeX / (double)(this.page.x * this.nrcols);
        double percentScreenY = actualSizeY / (double)(this.page.y * this.nrrows);
        gc.drawImage(this.image, 0, 0, imd.width, imd.height, 0, 0, (int)((double)width * percentScreenX), (int)((double)height * percentScreenY));
        StringBuilder text = new StringBuilder();
        text.append(this.nrcols).append("x").append(this.nrrows).append(" @ ").append(this.scale).append("%");
        gc.drawText(text.toString(), 0, 0);
        for (int c = 1; c < this.nrcols; ++c) {
            gc.drawLine(c * (width / this.nrcols), 0, c * (width / this.nrcols), height);
        }
        for (int r = 1; r < this.nrrows; ++r) {
            gc.drawLine(0, r * (height / this.nrrows), width, r * (height / this.nrrows));
        }
    }
}

