/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.commons.math3.distribution.ConstantRealDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.distribution.ZipfDistribution;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class SyntheticOptions
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 0L;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized long keySizeBytes = 1L;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized long valueSizeBytes = 1L;
    @JsonProperty
    public final @UnknownKeyFor @NonNull @Initialized long bytesPerRecord;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized long numHotKeys;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized double hotKeyFraction;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized double largeKeyFraction = 0.0;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized double largeKeySizeBytes = 1000.0;
    @JsonIgnore
    public @UnknownKeyFor @NonNull @Initialized int seed = 1;
    @JsonIgnore
    private transient @UnknownKeyFor @NonNull @Initialized HashFunction hashFunction;
    @JsonDeserialize(using=SamplerDeserializer.class)
    @UnknownKeyFor @NonNull @Initialized Sampler delayDistribution = SyntheticOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(0.0));
    @JsonProperty
    public final @UnknownKeyFor @NonNull @Initialized DelayType delayType = DelayType.SLEEP;
    @JsonProperty
    public final @UnknownKeyFor @NonNull @Initialized double cpuUtilizationInMixedDelay;

    public static @UnknownKeyFor @NonNull @Initialized Sampler fromRealDistribution(final @UnknownKeyFor @NonNull @Initialized RealDistribution dist) {
        return new Sampler(){
            private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 0L;

            @Override
            public @UnknownKeyFor @NonNull @Initialized double sample(@UnknownKeyFor @NonNull @Initialized long seed) {
                dist.reseedRandomGenerator(seed);
                return dist.sample();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object getDistribution() {
                return dist;
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized Sampler fromIntegerDistribution(final @UnknownKeyFor @NonNull @Initialized IntegerDistribution dist) {
        return new Sampler(){
            private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 0L;

            @Override
            public @UnknownKeyFor @NonNull @Initialized double sample(@UnknownKeyFor @NonNull @Initialized long seed) {
                dist.reseedRandomGenerator(seed);
                return dist.sample();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object getDistribution() {
                return dist;
            }
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized Sampler scaledSampler(final @UnknownKeyFor @NonNull @Initialized Sampler sampler, final @UnknownKeyFor @NonNull @Initialized double multiplier) {
        return new Sampler(){
            private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 0L;

            @Override
            public @UnknownKeyFor @NonNull @Initialized double sample(@UnknownKeyFor @NonNull @Initialized long seed) {
                return multiplier * sampler.sample(seed);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object getDistribution() {
                return sampler.getDistribution();
            }
        };
    }

    SyntheticOptions() {
        this.cpuUtilizationInMixedDelay = 0.1;
        this.bytesPerRecord = -1L;
    }

    @JsonDeserialize
    public void setSeed(@UnknownKeyFor @NonNull @Initialized int seed) {
        this.seed = seed;
    }

    public @UnknownKeyFor @NonNull @Initialized HashFunction hashFunction() {
        if (this.hashFunction == null) {
            this.hashFunction = Hashing.murmur3_128((int)this.seed);
        }
        return this.hashFunction;
    }

    public void validate() {
        Preconditions.checkArgument((this.keySizeBytes > 0L ? 1 : 0) != 0, (String)"keySizeBytes should be a positive number, but found %s", (long)this.keySizeBytes);
        Preconditions.checkArgument((this.valueSizeBytes >= 0L ? 1 : 0) != 0, (String)"valueSizeBytes should be a non-negative number, but found %s", (long)this.valueSizeBytes);
        Preconditions.checkArgument((this.numHotKeys >= 0L ? 1 : 0) != 0, (String)"numHotKeys should be a non-negative number, but found %s", (long)this.numHotKeys);
        Preconditions.checkArgument((this.hotKeyFraction >= 0.0 ? 1 : 0) != 0, (String)"hotKeyFraction should be a non-negative number, but found %s", (Object)this.hotKeyFraction);
        if (this.hotKeyFraction > 0.0) {
            int intBytes = 4;
            Preconditions.checkArgument((this.keySizeBytes >= (long)intBytes ? 1 : 0) != 0, (String)"Allowing hot keys (hotKeyFraction=%s) requires keySizeBytes to be at least %s, but found %s", (Object)this.hotKeyFraction, (Object)intBytes, (Object)this.keySizeBytes);
        }
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized long nextDelay(@UnknownKeyFor @NonNull @Initialized long seed) {
        return (long)this.delayDistribution.sample(seed);
    }

    public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> genKvPair(@UnknownKeyFor @NonNull @Initialized long seed) {
        Random random = new Random(seed);
        byte[] key = new byte[(int)this.keySizeBytes];
        int i = 0;
        while ((long)i < this.keySizeBytes) {
            key[i] = 42;
            ++i;
        }
        if (random.nextDouble() < this.hotKeyFraction) {
            int randInt = random.nextInt((int)this.numHotKeys);
            ByteBuffer.wrap(key).putInt(this.hashFunction().hashInt(randInt).asInt());
        } else {
            random.nextBytes(key);
        }
        byte[] val = new byte[(int)this.valueSizeBytes];
        random.nextBytes(val);
        return KV.of((Object)key, (Object)val);
    }

    public static <T extends SyntheticOptions> T fromJsonString(@UnknownKeyFor @NonNull @Initialized String json, @UnknownKeyFor @NonNull @Initialized Class<T> type) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ObjectMapper mapper = new ObjectMapper();
        SyntheticOptions result = (SyntheticOptions)mapper.readValue(json, type);
        result.validate();
        return (T)result;
    }

    static class SamplerDeserializer
    extends JsonDeserializer<Sampler> {
        SamplerDeserializer() {
        }

        public @UnknownKeyFor @NonNull @Initialized Sampler deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jp, @UnknownKeyFor @NonNull @Initialized DeserializationContext ctxt) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String type;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            switch (type = node.get("type").asText()) {
                case "uniform": {
                    double lowerBound = node.get("lower").asDouble();
                    double upperBound = node.get("upper").asDouble();
                    Preconditions.checkArgument((lowerBound >= 0.0 ? 1 : 0) != 0, (String)"The lower bound of uniform distribution should be a non-negative number, but found %s.", (Object)lowerBound);
                    return SyntheticOptions.fromRealDistribution((RealDistribution)new UniformRealDistribution(lowerBound, upperBound));
                }
                case "exp": {
                    double mean = node.get("mean").asDouble();
                    return SyntheticOptions.fromRealDistribution((RealDistribution)new ExponentialDistribution(mean));
                }
                case "normal": {
                    double mean = node.get("mean").asDouble();
                    double stddev = node.get("stddev").asDouble();
                    Preconditions.checkArgument((mean >= 0.0 ? 1 : 0) != 0, (String)"The mean of normal distribution should be a non-negative number, but found %s.", (Object)mean);
                    return SyntheticOptions.fromRealDistribution((RealDistribution)new NormalDistribution(mean, stddev));
                }
                case "const": {
                    double constant = node.get("const").asDouble();
                    Preconditions.checkArgument((constant >= 0.0 ? 1 : 0) != 0, (String)"The value of constant distribution should be a non-negative number, but found %s.", (Object)constant);
                    return SyntheticOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(constant));
                }
                case "zipf": {
                    double param = node.get("param").asDouble();
                    double multiplier = node.has("multiplier") ? node.get("multiplier").asDouble() : 1.0;
                    Preconditions.checkArgument((param > 1.0 ? 1 : 0) != 0, (String)"The parameter of the Zipf distribution should be > 1, but found %s.", (Object)param);
                    Preconditions.checkArgument((multiplier >= 0.0 ? 1 : 0) != 0, (String)"The multiplier of the Zipf distribution should be >= 0, but found %s.", (Object)multiplier);
                    ZipfDistribution dist = new ZipfDistribution(100, param);
                    return SyntheticOptions.scaledSampler(SyntheticOptions.fromIntegerDistribution((IntegerDistribution)dist), multiplier);
                }
            }
            throw new IllegalArgumentException("Unknown distribution type: " + type);
        }
    }

    public static interface Sampler
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized double sample(@UnknownKeyFor @NonNull @Initialized long var1);

        public @UnknownKeyFor @NonNull @Initialized Object getDistribution();
    }

    public static enum DelayType {
        SLEEP,
        CPU,
        MIXED;

    }
}

