/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.gettablenames;

import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.gettablenames.GetTableNamesMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GetTableNamesDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = GetTableNamesMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Text wTableNameField;
    private Text wSqlCreationField;
    private Button wIncludeTable;
    private Button wIncludeSchema;
    private Button wIncludeCatalog;
    private Label wlIncludeCatalog;
    private Button wIncludeProcedure;
    private Button wIncludeSynonym;
    private Button wAddSchemaInOutput;
    private Button wIncludeView;
    private Text wObjectTypeField;
    private Text wIsSystemObjectField;
    private Label wlSchemaName;
    private TextVar wSchemaName;
    private Button wDynamicSchema;
    private Label wlSchemaField;
    private CCombo wSchemaField;
    private final GetTableNamesMeta input;
    private boolean gotPreviousFields = false;

    public GetTableNamesDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)((GetTableNamesMeta)((Object)in)), pipelineMeta, sname);
        this.input = (GetTableNamesMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.Preview.Button", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getDatabase(), null);
        this.wlSchemaName = new Label((Composite)this.shell, 131072);
        this.wlSchemaName.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.SchemaNameName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSchemaName);
        FormData fdlschemaname = new FormData();
        fdlschemaname.left = new FormAttachment(0, 0);
        fdlschemaname.right = new FormAttachment(middle, -margin);
        fdlschemaname.top = new FormAttachment(this.wConnection, 2 * margin);
        this.wlSchemaName.setLayoutData((Object)fdlschemaname);
        this.wSchemaName = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wSchemaName.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.SchemaNameName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSchemaName);
        FormData fdschemaname = new FormData();
        fdschemaname.left = new FormAttachment(middle, 0);
        fdschemaname.top = new FormAttachment(this.wConnection, 2 * margin);
        fdschemaname.right = new FormAttachment(100, 0);
        this.wSchemaName.setLayoutData((Object)fdschemaname);
        ModifyListener lsModSchema = e -> this.refreshIncludeCatalog();
        this.wSchemaName.addModifyListener(lsModSchema);
        Label wlDynamicSchema = new Label((Composite)this.shell, 131072);
        wlDynamicSchema.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.DynamicSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDynamicSchema);
        FormData fdldynamicSchema = new FormData();
        fdldynamicSchema.left = new FormAttachment(0, -margin);
        fdldynamicSchema.top = new FormAttachment((Control)this.wSchemaName, margin);
        fdldynamicSchema.right = new FormAttachment(middle, -margin);
        wlDynamicSchema.setLayoutData((Object)fdldynamicSchema);
        this.wDynamicSchema = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wDynamicSchema);
        this.wDynamicSchema.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.DynamicSchema.Tooltip", (String[])new String[0]));
        FormData fddynamicSchema = new FormData();
        fddynamicSchema.left = new FormAttachment(middle, 0);
        fddynamicSchema.top = new FormAttachment((Control)wlDynamicSchema, 0, 0x1000000);
        this.wDynamicSchema.setLayoutData((Object)fddynamicSchema);
        this.wDynamicSchema.addListener(13, e -> this.activateDynamicSchema());
        this.wlSchemaField = new Label((Composite)this.shell, 131072);
        this.wlSchemaField.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.SchemaField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSchemaField);
        FormData fdlSchemaField = new FormData();
        fdlSchemaField.left = new FormAttachment(0, -margin);
        fdlSchemaField.top = new FormAttachment((Control)this.wDynamicSchema, margin);
        fdlSchemaField.right = new FormAttachment(middle, -margin);
        this.wlSchemaField.setLayoutData((Object)fdlSchemaField);
        this.wSchemaField = new CCombo((Composite)this.shell, 2056);
        this.wSchemaField.setEditable(true);
        PropsUi.setLook((Widget)this.wSchemaField);
        FormData fdSchemaField = new FormData();
        fdSchemaField.left = new FormAttachment(middle, 0);
        fdSchemaField.top = new FormAttachment((Control)this.wDynamicSchema, margin);
        fdSchemaField.right = new FormAttachment(100, -margin);
        this.wSchemaField.setLayoutData((Object)fdSchemaField);
        this.wSchemaField.addListener(15, e -> {
            this.setSchemaField();
            this.shell.setCursor(null);
        });
        Group wSettings = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.wSettings.Label", (String[])new String[0]));
        FormLayout settingsgroupLayout = new FormLayout();
        settingsgroupLayout.marginWidth = 10;
        settingsgroupLayout.marginHeight = 10;
        wSettings.setLayout((Layout)settingsgroupLayout);
        this.wlIncludeCatalog = new Label((Composite)wSettings, 131072);
        this.wlIncludeCatalog.setText(BaseMessages.getString(PKG, (String)"GetCatalogNamesDialog.IncludeCatalog.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlIncludeCatalog);
        FormData fdlIncludeCatalog = new FormData();
        fdlIncludeCatalog.left = new FormAttachment(0, -margin);
        fdlIncludeCatalog.top = new FormAttachment((Control)this.wSchemaField, margin);
        fdlIncludeCatalog.right = new FormAttachment(middle, -2 * margin);
        this.wlIncludeCatalog.setLayoutData((Object)fdlIncludeCatalog);
        this.wIncludeCatalog = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wIncludeCatalog);
        this.wIncludeCatalog.setToolTipText(BaseMessages.getString(PKG, (String)"GetCatalogNamesDialog.IncludeCatalog.Tooltip", (String[])new String[0]));
        FormData fdIncludeCatalog = new FormData();
        fdIncludeCatalog.left = new FormAttachment(middle, -margin);
        fdIncludeCatalog.top = new FormAttachment((Control)this.wlIncludeCatalog, 0, 0x1000000);
        this.wIncludeCatalog.setLayoutData((Object)fdIncludeCatalog);
        Label wlIncludeSchema = new Label((Composite)wSettings, 131072);
        wlIncludeSchema.setText(BaseMessages.getString(PKG, (String)"GetSchemaNamesDialog.IncludeSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludeSchema);
        FormData fdlincludeSchema = new FormData();
        fdlincludeSchema.left = new FormAttachment(0, -margin);
        fdlincludeSchema.top = new FormAttachment((Control)this.wIncludeCatalog, margin);
        fdlincludeSchema.right = new FormAttachment(middle, -2 * margin);
        wlIncludeSchema.setLayoutData((Object)fdlincludeSchema);
        this.wIncludeSchema = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wIncludeSchema);
        this.wIncludeSchema.setToolTipText(BaseMessages.getString(PKG, (String)"GetSchemaNamesDialog.IncludeSchema.Tooltip", (String[])new String[0]));
        FormData fdincludeSchema = new FormData();
        fdincludeSchema.left = new FormAttachment(middle, -margin);
        fdincludeSchema.top = new FormAttachment((Control)wlIncludeSchema, 0, 0x1000000);
        this.wIncludeSchema.setLayoutData((Object)fdincludeSchema);
        SelectionAdapter lincludeSchema = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetTableNamesDialog.this.input.setChanged();
            }
        };
        this.wIncludeSchema.addSelectionListener((SelectionListener)lincludeSchema);
        Label wlIncludeTable = new Label((Composite)wSettings, 131072);
        wlIncludeTable.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IncludeTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludeTable);
        FormData fdlincludeTable = new FormData();
        fdlincludeTable.left = new FormAttachment(0, -margin);
        fdlincludeTable.top = new FormAttachment((Control)this.wIncludeSchema, margin);
        fdlincludeTable.right = new FormAttachment(middle, -2 * margin);
        wlIncludeTable.setLayoutData((Object)fdlincludeTable);
        this.wIncludeTable = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wIncludeTable);
        this.wIncludeTable.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IncludeTable.Tooltip", (String[])new String[0]));
        FormData fdincludeTable = new FormData();
        fdincludeTable.left = new FormAttachment(middle, -margin);
        fdincludeTable.top = new FormAttachment((Control)wlIncludeTable, 0, 0x1000000);
        this.wIncludeTable.setLayoutData((Object)fdincludeTable);
        SelectionAdapter lincludeTable = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetTableNamesDialog.this.input.setChanged();
            }
        };
        this.wIncludeTable.addSelectionListener((SelectionListener)lincludeTable);
        Label wlIncludeView = new Label((Composite)wSettings, 131072);
        wlIncludeView.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IncludeView.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludeView);
        FormData fdlincludeView = new FormData();
        fdlincludeView.left = new FormAttachment(0, -margin);
        fdlincludeView.top = new FormAttachment((Control)this.wIncludeTable, margin);
        fdlincludeView.right = new FormAttachment(middle, -2 * margin);
        wlIncludeView.setLayoutData((Object)fdlincludeView);
        this.wIncludeView = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wIncludeView);
        this.wIncludeView.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IncludeView.Tooltip", (String[])new String[0]));
        FormData fdincludeView = new FormData();
        fdincludeView.left = new FormAttachment(middle, -margin);
        fdincludeView.top = new FormAttachment((Control)wlIncludeView, 0, 0x1000000);
        this.wIncludeView.setLayoutData((Object)fdincludeView);
        SelectionAdapter lincludeView = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetTableNamesDialog.this.input.setChanged();
            }
        };
        this.wIncludeView.addSelectionListener((SelectionListener)lincludeView);
        Label wlIncludeProcedure = new Label((Composite)wSettings, 131072);
        wlIncludeProcedure.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IncludeProcedure.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludeProcedure);
        FormData fdlincludeProcedure = new FormData();
        fdlincludeProcedure.left = new FormAttachment(0, -margin);
        fdlincludeProcedure.top = new FormAttachment((Control)this.wIncludeView, margin);
        fdlincludeProcedure.right = new FormAttachment(middle, -2 * margin);
        wlIncludeProcedure.setLayoutData((Object)fdlincludeProcedure);
        this.wIncludeProcedure = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wIncludeProcedure);
        this.wIncludeProcedure.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IncludeProcedure.Tooltip", (String[])new String[0]));
        FormData fdincludeProcedure = new FormData();
        fdincludeProcedure.left = new FormAttachment(middle, -margin);
        fdincludeProcedure.top = new FormAttachment((Control)wlIncludeProcedure, 0, 0x1000000);
        this.wIncludeProcedure.setLayoutData((Object)fdincludeProcedure);
        SelectionAdapter lincludeProcedure = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetTableNamesDialog.this.input.setChanged();
            }
        };
        this.wIncludeProcedure.addSelectionListener((SelectionListener)lincludeProcedure);
        Label wlIncludeSynonym = new Label((Composite)wSettings, 131072);
        wlIncludeSynonym.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.includeSynonym.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludeSynonym);
        FormData fdlincludeSynonym = new FormData();
        fdlincludeSynonym.left = new FormAttachment(0, -margin);
        fdlincludeSynonym.top = new FormAttachment((Control)this.wIncludeProcedure, margin);
        fdlincludeSynonym.right = new FormAttachment(middle, -2 * margin);
        wlIncludeSynonym.setLayoutData((Object)fdlincludeSynonym);
        this.wIncludeSynonym = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wIncludeSynonym);
        this.wIncludeSynonym.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IncludeSynonym.Tooltip", (String[])new String[0]));
        FormData fdincludeSynonym = new FormData();
        fdincludeSynonym.left = new FormAttachment(middle, -margin);
        fdincludeSynonym.top = new FormAttachment((Control)wlIncludeSynonym, 0, 0x1000000);
        this.wIncludeSynonym.setLayoutData((Object)fdincludeSynonym);
        SelectionAdapter lincludeSynonym = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetTableNamesDialog.this.input.setChanged();
            }
        };
        this.wIncludeSynonym.addSelectionListener((SelectionListener)lincludeSynonym);
        Label wlAddSchemaInOutput = new Label((Composite)wSettings, 131072);
        wlAddSchemaInOutput.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.AddSchemaInOutput.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddSchemaInOutput);
        FormData fdladdSchemaInOutput = new FormData();
        fdladdSchemaInOutput.left = new FormAttachment(0, -margin);
        fdladdSchemaInOutput.top = new FormAttachment((Control)this.wIncludeSynonym, 2 * margin);
        fdladdSchemaInOutput.right = new FormAttachment(middle, -2 * margin);
        wlAddSchemaInOutput.setLayoutData((Object)fdladdSchemaInOutput);
        this.wAddSchemaInOutput = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wAddSchemaInOutput);
        this.wAddSchemaInOutput.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.addSchemaInOutput.Tooltip", (String[])new String[0]));
        FormData fdaddSchemaInOutput = new FormData();
        fdaddSchemaInOutput.left = new FormAttachment(middle, -margin);
        fdaddSchemaInOutput.top = new FormAttachment((Control)wlAddSchemaInOutput, 0, 0x1000000);
        this.wAddSchemaInOutput.setLayoutData((Object)fdaddSchemaInOutput);
        SelectionAdapter laddSchemaInOutput = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetTableNamesDialog.this.input.setChanged();
            }
        };
        this.wAddSchemaInOutput.addSelectionListener((SelectionListener)laddSchemaInOutput);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)this.wSchemaField, 2 * margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        Group wOutputFields = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wOutputFields);
        wOutputFields.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.wOutputFields.Label", (String[])new String[0]));
        FormLayout outputFieldsgroupLayout = new FormLayout();
        outputFieldsgroupLayout.marginWidth = 10;
        outputFieldsgroupLayout.marginHeight = 10;
        wOutputFields.setLayout((Layout)outputFieldsgroupLayout);
        Label wlTableNameField = new Label((Composite)wOutputFields, 131072);
        wlTableNameField.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.TableNameFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTableNameField);
        FormData fdlTableNameField = new FormData();
        fdlTableNameField.left = new FormAttachment(0, 0);
        fdlTableNameField.right = new FormAttachment(middle, -margin);
        fdlTableNameField.top = new FormAttachment((Control)wSettings, margin * 2);
        wlTableNameField.setLayoutData((Object)fdlTableNameField);
        this.wTableNameField = new Text((Composite)wOutputFields, 18436);
        this.wTableNameField.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.TableNameFieldName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTableNameField);
        FormData fdTableNameField = new FormData();
        fdTableNameField.left = new FormAttachment(middle, 0);
        fdTableNameField.top = new FormAttachment((Control)wSettings, margin * 2);
        fdTableNameField.right = new FormAttachment(100, 0);
        this.wTableNameField.setLayoutData((Object)fdTableNameField);
        Label wlObjectTypeField = new Label((Composite)wOutputFields, 131072);
        wlObjectTypeField.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectTypeFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlObjectTypeField);
        FormData fdlObjectTypeField = new FormData();
        fdlObjectTypeField.left = new FormAttachment(0, 0);
        fdlObjectTypeField.right = new FormAttachment(middle, -margin);
        fdlObjectTypeField.top = new FormAttachment((Control)this.wTableNameField, margin);
        wlObjectTypeField.setLayoutData((Object)fdlObjectTypeField);
        this.wObjectTypeField = new Text((Composite)wOutputFields, 18436);
        this.wObjectTypeField.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectTypeFieldName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wObjectTypeField);
        FormData fdObjectTypeField = new FormData();
        fdObjectTypeField.left = new FormAttachment(middle, 0);
        fdObjectTypeField.top = new FormAttachment((Control)this.wTableNameField, margin);
        fdObjectTypeField.right = new FormAttachment(100, 0);
        this.wObjectTypeField.setLayoutData((Object)fdObjectTypeField);
        Label wlisSystemObjectField = new Label((Composite)wOutputFields, 131072);
        wlisSystemObjectField.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IsSystemObjectFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlisSystemObjectField);
        FormData fdlisSystemObjectField = new FormData();
        fdlisSystemObjectField.left = new FormAttachment(0, 0);
        fdlisSystemObjectField.right = new FormAttachment(middle, -margin);
        fdlisSystemObjectField.top = new FormAttachment((Control)this.wObjectTypeField, margin);
        wlisSystemObjectField.setLayoutData((Object)fdlisSystemObjectField);
        this.wIsSystemObjectField = new Text((Composite)wOutputFields, 18436);
        this.wIsSystemObjectField.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.IsSystemObjectFieldName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wIsSystemObjectField);
        FormData fdisSystemObjectField = new FormData();
        fdisSystemObjectField.left = new FormAttachment(middle, 0);
        fdisSystemObjectField.top = new FormAttachment((Control)this.wObjectTypeField, margin);
        fdisSystemObjectField.right = new FormAttachment(100, 0);
        this.wIsSystemObjectField.setLayoutData((Object)fdisSystemObjectField);
        Label wlSqlCreationField = new Label((Composite)wOutputFields, 131072);
        wlSqlCreationField.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.CreationSQLName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSqlCreationField);
        FormData fdlSqlCreationField = new FormData();
        fdlSqlCreationField.left = new FormAttachment(0, 0);
        fdlSqlCreationField.right = new FormAttachment(middle, -margin);
        fdlSqlCreationField.top = new FormAttachment((Control)this.wIsSystemObjectField, margin);
        wlSqlCreationField.setLayoutData((Object)fdlSqlCreationField);
        this.wSqlCreationField = new Text((Composite)wOutputFields, 18436);
        this.wSqlCreationField.setToolTipText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.CreationSQLName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSqlCreationField);
        FormData fdSqlCreationField = new FormData();
        fdSqlCreationField.left = new FormAttachment(middle, 0);
        fdSqlCreationField.top = new FormAttachment((Control)this.wIsSystemObjectField, margin);
        fdSqlCreationField.right = new FormAttachment(100, 0);
        this.wSqlCreationField.setLayoutData((Object)fdSqlCreationField);
        FormData fdOutputFields = new FormData();
        fdOutputFields.left = new FormAttachment(0, margin);
        fdOutputFields.top = new FormAttachment((Control)wSettings, 2 * margin);
        fdOutputFields.right = new FormAttachment(100, -margin);
        fdOutputFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wOutputFields.setLayoutData((Object)fdOutputFields);
        this.getData();
        this.activateDynamicSchema();
        this.refreshIncludeCatalog();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void refreshIncludeCatalog() {
        if (!Utils.isEmpty((CharSequence)this.wSchemaName.getText())) {
            this.wIncludeCatalog.setSelection(false);
            this.wlIncludeCatalog.setEnabled(false);
            this.wIncludeCatalog.setEnabled(false);
        } else {
            this.wlIncludeCatalog.setEnabled(true);
            this.wIncludeCatalog.setEnabled(true);
        }
    }

    private void activateDynamicSchema() {
        this.wlSchemaField.setEnabled(this.wDynamicSchema.getSelection());
        this.wSchemaField.setEnabled(this.wDynamicSchema.getSelection());
        this.wPreview.setEnabled(!this.wDynamicSchema.getSelection());
        this.wlSchemaName.setEnabled(!this.wDynamicSchema.getSelection());
        this.wSchemaName.setEnabled(!this.wDynamicSchema.getSelection());
        if (this.wDynamicSchema.getSelection()) {
            this.wIncludeCatalog.setSelection(false);
        }
        this.wlIncludeCatalog.setEnabled(!this.wDynamicSchema.getSelection());
        this.wIncludeCatalog.setEnabled(!this.wDynamicSchema.getSelection());
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"GetTableNamesDialog.Log.GettingKeyInfo", (String[])new String[0])});
        }
        if (this.input.getDatabase() != null) {
            this.wConnection.setText(this.input.getDatabase().getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchemaName.setText(this.input.getSchemaName());
        }
        if (this.input.getTableNameFieldName() != null) {
            this.wTableNameField.setText(this.input.getTableNameFieldName());
        }
        if (this.input.getObjectTypeFieldName() != null) {
            this.wObjectTypeField.setText(this.input.getObjectTypeFieldName());
        }
        if (this.input.isSystemObjectFieldName() != null) {
            this.wIsSystemObjectField.setText(this.input.isSystemObjectFieldName());
        }
        if (this.input.getSqlCreationFieldName() != null) {
            this.wSqlCreationField.setText(this.input.getSqlCreationFieldName());
        }
        this.wIncludeCatalog.setSelection(this.input.isIncludeCatalog());
        this.wIncludeSchema.setSelection(this.input.isIncludeSchema());
        this.wIncludeTable.setSelection(this.input.isIncludeTable());
        this.wIncludeView.setSelection(this.input.isIncludeView());
        this.wIncludeProcedure.setSelection(this.input.isIncludeProcedure());
        this.wIncludeSynonym.setSelection(this.input.isIncludeSynonym());
        this.wAddSchemaInOutput.setSelection(this.input.isAddSchemaInOutput());
        this.wDynamicSchema.setSelection(this.input.isDynamicSchema());
        if (this.input.getSchemaNameField() != null) {
            this.wSchemaField.setText(this.input.getSchemaNameField());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void setSchemaField() {
        if (!this.gotPreviousFields) {
            try {
                String value = this.wSchemaField.getText();
                this.wSchemaField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wSchemaField.setItems(r.getFieldNames());
                }
                if (value != null) {
                    this.wSchemaField.setText(value);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetTableNamesDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetTableNamesDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        if (this.input.getDatabase() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        this.input.setChanged();
        this.dispose();
    }

    private void getInfo(GetTableNamesMeta info) {
        try {
            info.setDatabase(DatabaseMeta.loadDatabase((IHopMetadataProvider)this.getMetadataProvider(), (String)this.wConnection.getText()));
        }
        catch (Exception e) {
            info.setDatabase(null);
            new ErrorDialog(this.shell, "Error", "Error loading database connection", e);
        }
        info.setSchemaName(this.wSchemaName.getText());
        info.setTableNameFieldName(this.wTableNameField.getText());
        info.setSqlCreationFieldName(this.wSqlCreationField.getText());
        info.setObjectTypeFieldName(this.wObjectTypeField.getText());
        info.setIsSystemObjectFieldName(this.wIsSystemObjectField.getText());
        info.setIncludeCatalog(this.wIncludeCatalog.getSelection());
        info.setIncludeSchema(this.wIncludeSchema.getSelection());
        info.setIncludeTable(this.wIncludeTable.getSelection());
        info.setIncludeView(this.wIncludeView.getSelection());
        info.setIncludeProcedure(this.wIncludeProcedure.getSelection());
        info.setIncludeSynonym(this.wIncludeSynonym.getSelection());
        info.setAddSchemaInOutput(this.wAddSchemaInOutput.getSelection());
        info.setDynamicSchema(this.wDynamicSchema.getSelection());
        info.setSchemaNameField(this.wSchemaField.getText());
    }

    private boolean checkUserInput(GetTableNamesMeta meta) {
        if (Utils.isEmpty((CharSequence)meta.getTableNameFieldName())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.Error.TableNameFieldNameMissingMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.Error.TableNameFieldNameMissingTitle", (String[])new String[0]));
            mb.open();
            return false;
        }
        return true;
    }

    private void preview() {
        GetTableNamesMeta oneMeta = new GetTableNamesMeta();
        this.getInfo(oneMeta);
        if (oneMeta.getDatabase() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"GetTableNamesDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        if (!this.checkUserInput(oneMeta)) {
            return;
        }
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GetTableNamesDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetTableNamesDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ErrorInPreview.DialogMessage", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                prd.open();
            }
        }
    }
}

