/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.NanoClock;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.extensions.gcp.util.CustomHttpErrors;
import org.apache.beam.sdk.extensions.gcp.util.HttpRequestWrapper;
import org.apache.beam.sdk.extensions.gcp.util.HttpResponseWrapper;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHttpRequestInitializer
implements HttpRequestInitializer {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(RetryHttpRequestInitializer.class);
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> DEFAULT_IGNORED_RESPONSE_CODES = new HashSet<Integer>(Arrays.asList(307, 308));
    private static final @UnknownKeyFor @NonNull @Initialized int HANGING_GET_TIMEOUT_SEC = 80;
    private @UnknownKeyFor @NonNull @Initialized int writeTimeout;
    private final @UnknownKeyFor @NonNull @Initialized HttpResponseInterceptor responseInterceptor;
    private @UnknownKeyFor @NonNull @Initialized CustomHttpErrors customHttpErrors = null;
    private final @UnknownKeyFor @NonNull @Initialized NanoClock nanoClock;
    private final @UnknownKeyFor @NonNull @Initialized Sleeper sleeper;
    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> ignoredResponseCodes = new HashSet<Integer>(DEFAULT_IGNORED_RESPONSE_CODES);

    public RetryHttpRequestInitializer() {
        this(Collections.emptyList());
    }

    public RetryHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Integer> additionalIgnoredResponseCodes) {
        this(additionalIgnoredResponseCodes, null);
    }

    public RetryHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Integer> additionalIgnoredResponseCodes, @Nullable @UnknownKeyFor @Initialized HttpResponseInterceptor responseInterceptor) {
        this(NanoClock.SYSTEM, Sleeper.DEFAULT, additionalIgnoredResponseCodes, responseInterceptor);
    }

    RetryHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized NanoClock nanoClock, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Integer> additionalIgnoredResponseCodes, @UnknownKeyFor @NonNull @Initialized HttpResponseInterceptor responseInterceptor) {
        this.nanoClock = nanoClock;
        this.sleeper = sleeper;
        this.ignoredResponseCodes.addAll(additionalIgnoredResponseCodes);
        this.responseInterceptor = responseInterceptor;
        this.writeTimeout = 0;
    }

    public void initialize(@UnknownKeyFor @NonNull @Initialized HttpRequest request) throws @UnknownKeyFor @NonNull @Initialized IOException {
        request.setReadTimeout(80000);
        request.setWriteTimeout(this.writeTimeout);
        LoggingHttpBackOffHandler loggingHttpBackOffHandler = new LoggingHttpBackOffHandler(this.sleeper, (BackOff)new ExponentialBackOff.Builder().setNanoClock(this.nanoClock).setMultiplier(2.0).build(), (BackOff)new ExponentialBackOff.Builder().setNanoClock(this.nanoClock).setMultiplier(2.0).build(), this.ignoredResponseCodes, this.customHttpErrors);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)loggingHttpBackOffHandler);
        request.setIOExceptionHandler((HttpIOExceptionHandler)loggingHttpBackOffHandler);
        if (this.responseInterceptor != null) {
            request.setResponseInterceptor(this.responseInterceptor);
        }
    }

    public void setCustomErrors(@UnknownKeyFor @NonNull @Initialized CustomHttpErrors customErrors) {
        this.customHttpErrors = customErrors;
    }

    public void setWriteTimeout(@UnknownKeyFor @NonNull @Initialized int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    private static class LoggingHttpBackOffHandler
    implements HttpIOExceptionHandler,
    HttpUnsuccessfulResponseHandler {
        private final @UnknownKeyFor @NonNull @Initialized Sleeper sleeper;
        private final @UnknownKeyFor @NonNull @Initialized BackOff ioExceptionBackOff;
        private final @UnknownKeyFor @NonNull @Initialized BackOff unsuccessfulResponseBackOff;
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> ignoredResponseCodes;
        private final @UnknownKeyFor @NonNull @Initialized Counter throttlingMsecs = Metrics.counter(LoggingHttpBackOffHandler.class, (String)"throttling-msecs");
        private @UnknownKeyFor @NonNull @Initialized int ioExceptionRetries;
        private @UnknownKeyFor @NonNull @Initialized int unsuccessfulResponseRetries;
        private @Nullable @UnknownKeyFor @Initialized CustomHttpErrors customHttpErrors;

        private LoggingHttpBackOffHandler(@UnknownKeyFor @NonNull @Initialized Sleeper sleeper, @UnknownKeyFor @NonNull @Initialized BackOff ioExceptionBackOff, @UnknownKeyFor @NonNull @Initialized BackOff unsucessfulResponseBackOff, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> ignoredResponseCodes, @Nullable @UnknownKeyFor @Initialized CustomHttpErrors customHttpErrors) {
            this.sleeper = sleeper;
            this.ioExceptionBackOff = ioExceptionBackOff;
            this.unsuccessfulResponseBackOff = unsucessfulResponseBackOff;
            this.ignoredResponseCodes = ignoredResponseCodes;
            this.customHttpErrors = customHttpErrors;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean handleIOException(@UnknownKeyFor @NonNull @Initialized HttpRequest request, @UnknownKeyFor @NonNull @Initialized boolean supportsRetry) throws @UnknownKeyFor @NonNull @Initialized IOException {
            boolean willRetry;
            boolean bl = willRetry = supportsRetry && this.backOffWasSuccessful(this.ioExceptionBackOff);
            if (willRetry) {
                ++this.ioExceptionRetries;
                LOG.debug("Request failed with IOException, will retry: {}", (Object)request.getUrl());
            } else {
                String message = "Request failed with IOException, performed {} retries due to IOExceptions, performed {} retries due to unsuccessful status codes, HTTP framework says request {} be retried, (caller responsible for retrying): {}";
                LOG.warn(message, new Object[]{this.ioExceptionRetries, this.unsuccessfulResponseRetries, supportsRetry ? "can" : "cannot", request.getUrl()});
            }
            return willRetry;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean handleResponse(@UnknownKeyFor @NonNull @Initialized HttpRequest request, @UnknownKeyFor @NonNull @Initialized HttpResponse response, @UnknownKeyFor @NonNull @Initialized boolean supportsRetry) throws @UnknownKeyFor @NonNull @Initialized IOException {
            boolean willRetry;
            boolean bl = willRetry = supportsRetry && this.retryOnStatusCode(response.getStatusCode()) && this.backOffWasSuccessful(this.unsuccessfulResponseBackOff);
            if (willRetry) {
                ++this.unsuccessfulResponseRetries;
                LOG.debug("Request failed with code {}, will retry: {}", (Object)response.getStatusCode(), (Object)request.getUrl());
            } else {
                String error;
                String message = "Request failed with code {}, performed {} retries due to IOExceptions, performed {} retries due to unsuccessful status codes, HTTP framework says request {} be retried, (caller responsible for retrying): {}. {}";
                String customLogMessage = "";
                if (this.customHttpErrors != null && (error = this.customHttpErrors.getCustomError(new HttpRequestWrapper(request), new HttpResponseWrapper(response))) != null) {
                    customLogMessage = error;
                }
                if (this.ignoredResponseCodes.contains(response.getStatusCode())) {
                    LOG.debug(message, new Object[]{response.getStatusCode(), this.ioExceptionRetries, this.unsuccessfulResponseRetries, supportsRetry ? "can" : "cannot", request.getUrl(), customLogMessage});
                } else {
                    LOG.warn(message, new Object[]{response.getStatusCode(), this.ioExceptionRetries, this.unsuccessfulResponseRetries, supportsRetry ? "can" : "cannot", request.getUrl(), customLogMessage});
                }
            }
            return willRetry;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean backOffWasSuccessful(@UnknownKeyFor @NonNull @Initialized BackOff backOff) {
            try {
                long backOffTime = backOff.nextBackOffMillis();
                if (backOffTime == -1L) {
                    return false;
                }
                this.throttlingMsecs.inc(backOffTime);
                this.sleeper.sleep(backOffTime);
                return true;
            }
            catch (IOException | InterruptedException e) {
                return false;
            }
        }

        private @UnknownKeyFor @NonNull @Initialized boolean retryOnStatusCode(@UnknownKeyFor @NonNull @Initialized int statusCode) {
            return statusCode == 0 || statusCode / 100 == 5 || statusCode == 429;
        }
    }
}

