/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.metrics;

import com.google.cloud.bigtable.metrics.Counter;
import com.google.cloud.bigtable.metrics.DropwizardMetricRegistry;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.MetricRegistry;
import com.google.cloud.bigtable.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BigtableClientMetrics {
    private static final String METRIC_PREFIX = "google-cloud-bigtable.";
    private static MetricRegistry registry = MetricRegistry.NULL_METRICS_REGISTRY;
    private static MetricLevel levelToLog = MetricLevel.Info;

    public static void setMetricRegistry(MetricRegistry registry) {
        BigtableClientMetrics.registry = registry;
    }

    public static MetricRegistry getMetricRegistry(MetricLevel level) {
        return BigtableClientMetrics.isEnabled(level) ? registry : MetricRegistry.NULL_METRICS_REGISTRY;
    }

    public static Counter counter(MetricLevel level, String name) {
        return BigtableClientMetrics.getMetricRegistry(level).counter(METRIC_PREFIX + name);
    }

    public static Timer timer(MetricLevel level, String name) {
        return BigtableClientMetrics.getMetricRegistry(level).timer(METRIC_PREFIX + name);
    }

    public static Meter meter(MetricLevel level, String name) {
        return BigtableClientMetrics.getMetricRegistry(level).meter(METRIC_PREFIX + name);
    }

    public static void setLevelToLog(MetricLevel levelToLog) {
        BigtableClientMetrics.levelToLog = levelToLog;
    }

    public static MetricLevel getLevelToLog() {
        return levelToLog;
    }

    public static boolean isEnabled(MetricLevel level) {
        return levelToLog.getLevel() >= level.getLevel();
    }

    private BigtableClientMetrics() {
    }

    static {
        Logger logger = LoggerFactory.getLogger(BigtableClientMetrics.class);
        if (logger.isDebugEnabled()) {
            if (registry == MetricRegistry.NULL_METRICS_REGISTRY) {
                DropwizardMetricRegistry dropwizardRegistry = new DropwizardMetricRegistry();
                DropwizardMetricRegistry.createSlf4jReporter(dropwizardRegistry, logger, 1L, TimeUnit.MINUTES);
                BigtableClientMetrics.setMetricRegistry(dropwizardRegistry);
            } else if (registry instanceof DropwizardMetricRegistry) {
                DropwizardMetricRegistry dropwizardRegistry = (DropwizardMetricRegistry)registry;
                DropwizardMetricRegistry.createSlf4jReporter(dropwizardRegistry, logger, 1L, TimeUnit.MINUTES);
            } else {
                logger.info("Could not set up logging since the metrics registry is not a DropwizardMetricRegistry; it is a %s w.", (Object)registry.getClass().getName());
            }
        }
    }

    public static enum MetricLevel {
        Info(1),
        Debug(2),
        Trace(3);

        private final int level;

        private MetricLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

