/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.SystemStatus;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.AS400DetailsPane;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VSystemStatus;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VSystemStatusPane
extends JPanel
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    AS400DetailsPane detailsPane_;
    private AS400 system_;
    private SystemStatus systemStatus_;
    private VSystemStatus vSystemStatus_;
    private JLabel systemLabel_ = new JLabel();
    private JLabel dateTimeLabel_ = new JLabel();
    private JLabel utilizationLabel_ = new JLabel();
    private JLabel systemASPLabel_ = new JLabel();
    private JLabel systemASPUsedLabel_ = new JLabel();
    private JLabel totalAuxiliaryStorageLabel_ = new JLabel();
    private JLabel jobsInSystemLabel_ = new JLabel();
    private JLabel batchJobsRunningLabel_ = new JLabel();
    private JLabel usersCurrentlySignedOnLabel_ = new JLabel();
    private boolean allowModifyAllPools_ = false;
    private static DateFormat dateFormat_ = DateFormat.getDateInstance();
    private static DateFormat timeFormat_ = DateFormat.getTimeInstance();
    private static final String systemStatusText_ = ResourceLoader.getText("SYSTEM_STATUS_SYSTEM_STATUS");
    private static final String systemText_ = ResourceLoader.getText("SYSTEM_STATUS_SYSTEM") + ":";
    private static final String datetimeText_ = ResourceLoader.getText("SYSTEM_STATUS_DATE_TIME") + ":";
    private static final String cpuText_ = ResourceLoader.getText("SYSTEM_STATUS_CPU");
    private static final String utilizationText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_UTILIZATION") + ":";
    private static final String auxiliaryStorageText_ = ResourceLoader.getText("SYSTEM_STATUS_AUXILIARY_STORAGE");
    private static final String systemAspText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_SYSTEM_ASP") + ":";
    private static final String systemAspUsedText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_SYSTEM_ASP_USED") + ":";
    private static final String totalAuxiliaryStorageText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_TOTAL_AUXILIARY_STORAGE") + ":";
    private static final String jobsText_ = ResourceLoader.getText("SYSTEM_STATUS_JOBS");
    private static final String jobsInSystemText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_JOBS_IN_SYSTEM") + ":";
    private static final String batchJobsRunningText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_BATCH_JOBS_RUNNING") + ":";
    private static final String usersText_ = ResourceLoader.getText("SYSTEM_STATUS_USERS");
    private static final String usersCurrentlySignedOnText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_USERS_CURRENTLY_SIGNED_ON") + ":";
    private static final String storagePoolsText_ = ResourceLoader.getText("SYSTEM_STATUS_STORAGE_POOLS");
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VSystemStatusPane(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        VUtilities.constrain(this.getPanel0(), this, gridBagLayout, gridBagConstraints, 0, 1, 1, 0, 1, 0, 0, 10);
        VUtilities.constrain(this.getPanel1(), this, gridBagLayout, gridBagConstraints, 0, 1, 1, 1, 1, 0, 0, 10);
        VUtilities.constrain(new JLabel(storagePoolsText_), this, gridBagLayout, gridBagConstraints, 0, 1, 1, 2, 1, 0, 0, 17);
        VUtilities.constrain(this.getPanel2(), this, gridBagLayout, gridBagConstraints, 0, 1, 1, 3, 1, 1, 1, 10);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener == null) {
            throw new NullPointerException("listener");
        }
        this.listSelectionEventSupport_.addListSelectionListener(listSelectionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public VActionContext getActionContext() {
        return this.detailsPane_.getActionContext();
    }

    public boolean getAllowActions() {
        return this.detailsPane_.getAllowActions();
    }

    public TableColumnModel getDetailsColumnModel() {
        return this.detailsPane_.getColumnModel();
    }

    public TableModel getDetailsModel() {
        return this.detailsPane_.getModel();
    }

    public ListSelectionModel getDetailsSelectionModel() {
        return this.detailsPane_.getSelectionModel();
    }

    private JPanel getPanel0() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(systemStatusText_));
        return jPanel;
    }

    private JPanel getPanel1() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        int n = 0;
        VUtilities.constrain(new JLabel(systemText_), this.systemLabel_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(datetimeText_), this.dateTimeLabel_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(cpuText_), jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(utilizationText_), this.utilizationLabel_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(auxiliaryStorageText_), jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(systemAspText_), this.systemASPLabel_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(systemAspUsedText_), this.systemASPUsedLabel_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(totalAuxiliaryStorageText_), this.totalAuxiliaryStorageLabel_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(jobsText_), jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(jobsInSystemText_), this.jobsInSystemLabel_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(batchJobsRunningText_), this.batchJobsRunningLabel_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(usersText_), jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(usersCurrentlySignedOnText_), this.usersCurrentlySignedOnLabel_, jPanel, gridBagLayout, n++);
        return jPanel;
    }

    private JPanel getPanel2() {
        JPanel jPanel = new JPanel();
        this.detailsPane_ = new AS400DetailsPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", this.detailsPane_);
        return jPanel;
    }

    public VObject getSelectedObject() {
        VObject vObject = this.detailsPane_.getSelectedObject();
        return vObject;
    }

    public VObject[] getSelectedObjects() {
        VObject[] vObjectArray = this.detailsPane_.getSelectedObjects();
        return vObjectArray;
    }

    public VSystemStatus getVSystemStatus() {
        return this.vSystemStatus_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.detailsPane_.addErrorListener(this.errorEventSupport_);
        this.detailsPane_.addListSelectionListener(this.listSelectionEventSupport_);
        this.detailsPane_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.detailsPane_.addVetoableChangeListener(this.vetoableChangeSupport_);
    }

    public boolean isAllowModifyAllPools() {
        return this.allowModifyAllPools_;
    }

    public void load() {
        Object object;
        this.workingEventSupport_.fireStartWorking();
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "VSystemStatusPane: loading");
        }
        try {
            if (this.systemStatus_ == null) {
                this.systemStatus_ = new SystemStatus(this.system_);
            } else {
                this.systemStatus_.refreshCache();
            }
            object = this.systemStatus_.getSystemPools();
            while (object.hasMoreElements()) {
                ((SystemPool)object.nextElement()).addPropertyChangeListener(this.propertyChangeSupport_);
            }
        }
        catch (Exception exception) {
            Trace.log(2, exception.toString());
            this.errorEventSupport_.fireError(exception);
        }
        try {
            if (this.vSystemStatus_ == null) {
                this.vSystemStatus_ = new VSystemStatus(this.systemStatus_);
            } else {
                this.vSystemStatus_.load();
            }
        }
        catch (Exception exception) {
            Trace.log(2, exception.toString());
            this.errorEventSupport_.fireError(exception);
        }
        this.vSystemStatus_.setAllowModifyAllPools(this.allowModifyAllPools_);
        this.systemLabel_.setText(this.systemStatus_.getSystem().getSystemName());
        try {
            object = this.systemStatus_.getDateAndTimeStatusGathered();
            String string = dateFormat_.format((Date)object);
            String string2 = timeFormat_.format((Date)object);
            this.dateTimeLabel_.setText(string + "  " + string2);
            this.utilizationLabel_.setText(Float.toString(this.systemStatus_.getPercentProcessingUnitUsed()));
            this.systemASPLabel_.setText(Integer.toString(this.systemStatus_.getSystemASP()));
            this.systemASPUsedLabel_.setText(Float.toString(this.systemStatus_.getPercentSystemASPUsed()));
            this.totalAuxiliaryStorageLabel_.setText(Integer.toString(this.systemStatus_.getTotalAuxiliaryStorage()));
            this.jobsInSystemLabel_.setText(Integer.toString(this.systemStatus_.getJobsInSystem()));
            this.batchJobsRunningLabel_.setText(Integer.toString(this.systemStatus_.getBatchJobsRunning()));
            this.usersCurrentlySignedOnLabel_.setText(Integer.toString(this.systemStatus_.getUsersCurrentSignedOn()));
        }
        catch (Exception exception) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, exception);
            }
            this.errorEventSupport_.fireError(exception);
        }
        try {
            this.detailsPane_.setRoot(this.vSystemStatus_);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.detailsPane_.load();
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "VSystemStatusPane: load finished");
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener == null) {
            throw new NullPointerException("listener");
        }
        this.listSelectionEventSupport_.removeListSelectionListener(listSelectionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setAllowActions(boolean bl) {
        this.detailsPane_.setAllowActions(bl);
    }

    public void setAllowModifyAllPools(boolean bl) {
        this.allowModifyAllPools_ = bl;
    }

    public void setConfirm(boolean bl) {
        this.detailsPane_.setConfirm(bl);
    }

    public void setDetailsSelectionModel(ListSelectionModel listSelectionModel) {
        this.detailsPane_.setSelectionModel(listSelectionModel);
    }

    public void setRoot(VNode vNode) throws PropertyVetoException {
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        this.detailsPane_.setRoot(vNode);
    }

    public void sort(Object[] objectArray, boolean[] blArray) {
        this.detailsPane_.sort(objectArray, blArray);
    }
}

