/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.DLOPermission;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import com.ibm.as400.vaccess.PermissionMainPanel;
import com.ibm.as400.vaccess.PermissionNameCellObject;
import com.ibm.as400.vaccess.ResourceLoader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class PermissionTableModelDLO
extends DefaultTableModel {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Permission permission_;
    private Vector userPermissions_;
    private JTable table_;
    private PermissionMainPanel mainPanel_;
    private int selectedColumn_ = 1;
    private static String[] columnNames_;
    private static String addUserExceptionDialogMessage_;
    private static String addUserExceptionDialogTitle_;

    public PermissionTableModelDLO(PermissionMainPanel permissionMainPanel, Permission permission) {
        this.initializeTable();
        this.mainPanel_ = permissionMainPanel;
        this.permission_ = permission;
        Enumeration enumeration = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (enumeration.hasMoreElements()) {
            this.userPermissions_.addElement(enumeration.nextElement());
        }
    }

    public void addRow(String string) {
        try {
            this.permission_.addAuthorizedUser(string);
            this.mainPanel_.getApplyButton().setEnabled(true);
            this.table_.clearSelection();
            Enumeration enumeration = this.permission_.getUserPermissions();
            this.userPermissions_ = new Vector();
            while (enumeration.hasMoreElements()) {
                this.userPermissions_.addElement(enumeration.nextElement());
            }
            int n = this.userPermissions_.size() - 1;
            this.fireTableRowsInserted(n, n);
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            Trace.log(2, "Error in addRow : " + extendedIllegalArgumentException);
            this.mainPanel_.fireError(extendedIllegalArgumentException);
        }
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        return columnNames_.length;
    }

    public String getColumnName(int n) {
        return columnNames_[n];
    }

    public int getRowCount() {
        if (this.userPermissions_ == null) {
            return 0;
        }
        return this.userPermissions_.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.userPermissions_.size()) {
            return null;
        }
        if (this.selectedColumn_ > 0) {
            this.table_.clearSelection();
        } else if (this.table_.getSelectedRow() >= 0 && this.table_.getSelectedRowCount() > 0) {
            this.mainPanel_.getRemoveButton().setEnabled(true);
        }
        DLOPermission dLOPermission = null;
        dLOPermission = (DLOPermission)this.userPermissions_.elementAt(n);
        String string = dLOPermission.getDataAuthority().toUpperCase();
        Object object = null;
        switch (n2) {
            case 0: {
                object = new PermissionNameCellObject(dLOPermission.getUserID(), dLOPermission.getGroupIndicator());
                break;
            }
            case 1: {
                object = new Boolean(string.equals("*USE"));
                break;
            }
            case 2: {
                object = new Boolean(string.equals("*CHANGE"));
                break;
            }
            case 3: {
                object = new Boolean(string.equals("*ALL"));
                break;
            }
            case 4: {
                object = new Boolean(string.equals("*EXCLUDE"));
                break;
            }
            case 5: {
                object = new Boolean(dLOPermission.isFromAuthorizationList());
                break;
            }
            case 6: {
                object = new Boolean(string.equals("USER_DEF"));
            }
        }
        return object;
    }

    private void initializeTable() {
        columnNames_ = new String[7];
        PermissionTableModelDLO.columnNames_[0] = ResourceLoader.getText("OBJECT_USER_NAME");
        PermissionTableModelDLO.columnNames_[1] = ResourceLoader.getText("OBJECT_AUTHORITY_USE");
        PermissionTableModelDLO.columnNames_[2] = ResourceLoader.getText("OBJECT_AUTHORITY_CHANGE");
        PermissionTableModelDLO.columnNames_[3] = ResourceLoader.getText("OBJECT_AUTHORITY_ALL");
        PermissionTableModelDLO.columnNames_[4] = ResourceLoader.getText("OBJECT_AUTHORITY_EXCLUDE");
        PermissionTableModelDLO.columnNames_[5] = ResourceLoader.getText("OBJECT_FROM_AUTHORIZATION_LIST");
        PermissionTableModelDLO.columnNames_[6] = ResourceLoader.getText("OBJECT_AUTHORITY_USER_DEF");
        addUserExceptionDialogMessage_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_MESSAGE");
        addUserExceptionDialogTitle_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_TITLE");
    }

    public boolean isCellEditable(int n, int n2) {
        this.selectedColumn_ = n2;
        switch (n2) {
            case 0: {
                return false;
            }
            case 5: {
                UserPermission userPermission = (UserPermission)this.userPermissions_.elementAt(n);
                return !this.mainPanel_.getAutList().toUpperCase().equals("*NONE") && userPermission.getUserID().toUpperCase().equals("*PUBLIC");
            }
            case 6: {
                return false;
            }
        }
        return true;
    }

    public void removeRow(int n) {
        this.table_.clearSelection();
        DLOPermission dLOPermission = (DLOPermission)this.userPermissions_.elementAt(n);
        this.permission_.removeUserPermission(dLOPermission);
        Enumeration enumeration = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (enumeration.hasMoreElements()) {
            this.userPermissions_.addElement(enumeration.nextElement());
        }
        this.fireTableRowsDeleted(n, n);
    }

    void resetPublicAuthorizationList() {
        UserPermission userPermission = this.permission_.getUserPermission("*PUBLIC");
        int n = this.userPermissions_.indexOf(userPermission);
        if (n >= 0) {
            this.setValueAt(new Boolean(false), n, 5);
        }
    }

    public void setTableInstance(JTable jTable) {
        this.table_ = jTable;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.mainPanel_.getRemoveButton().setEnabled(false);
        DLOPermission dLOPermission = (DLOPermission)this.userPermissions_.elementAt(n);
        switch (n2) {
            case 1: {
                boolean bl = (Boolean)object;
                if (!bl) break;
                dLOPermission.setDataAuthority("*Use");
                break;
            }
            case 2: {
                boolean bl = (Boolean)object;
                if (!bl) break;
                dLOPermission.setDataAuthority("*Change");
                break;
            }
            case 3: {
                boolean bl = (Boolean)object;
                if (!bl) break;
                dLOPermission.setDataAuthority("*All");
                break;
            }
            case 4: {
                boolean bl = (Boolean)object;
                if (!bl) break;
                dLOPermission.setDataAuthority("*Exclude");
                break;
            }
            case 5: {
                boolean bl = (Boolean)object;
                dLOPermission.setFromAuthorizationList(bl);
            }
        }
        this.fireTableRowsUpdated(n, n);
        this.mainPanel_.getApplyButton().setEnabled(true);
    }
}

