/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util;

import com.ibm.as400.access.AS400JPing;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.Trace;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class JPing {
    private static String sys_;
    private static int srv_;
    private static boolean ssl_;
    private static boolean verbose_;
    private static long time_;
    private static ResourceBundle resource_;
    private static final int UNRECOGNIZED = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        try {
            if (!JPing.parseParms(stringArray, printWriter)) {
                JPing.usage(printWriter);
                return;
            }
            if (verbose_) {
                Trace.setTraceDiagnosticOn(true);
                Trace.setTraceOn(true);
            }
            AS400JPing aS400JPing = new AS400JPing(sys_, srv_, ssl_);
            aS400JPing.setTimeout(time_);
            aS400JPing.setPrintWriter(System.out);
            printWriter.println();
            printWriter.print(resource_.getString("JPING_VERIFYING"));
            printWriter.print(sys_);
            printWriter.println("...");
            printWriter.println();
            boolean bl = srv_ == 99 ? aS400JPing.pingAllServices() : aS400JPing.ping();
            if (bl) {
                printWriter.println(resource_.getString("JPING_VERIFIED"));
            } else {
                printWriter.println(resource_.getString("JPING_NOTVERIFIED"));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printWriter);
            if (Trace.isTraceOn()) {
                Trace.log(2, throwable);
            }
        }
        finally {
            try {
                System.exit(0);
            }
            catch (Exception exception) {}
        }
    }

    private static boolean parseParms(String[] stringArray, PrintWriter printWriter) throws Exception {
        if (stringArray.length == 0) {
            return false;
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("-service");
        vector.addElement("-ssl");
        vector.addElement("-timeout");
        vector.addElement("-verbose");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("-h", "-help");
        hashtable.put("-?", "-help");
        hashtable.put("-s", "-service");
        hashtable.put("-t", "-timeout");
        hashtable.put("-v", "-verbose");
        CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray, vector, hashtable);
        if (commandLineArguments.isOptionSpecified("-help")) {
            return false;
        }
        sys_ = commandLineArguments.getOptionValue("");
        if (sys_ == null || sys_.length() == 0 || sys_.indexOf(32) != -1) {
            return false;
        }
        String string = commandLineArguments.getOptionValue("-service");
        if (string != null && string.length() != 0 && (srv_ = JPing.toServiceNumber(string)) == -1) {
            printWriter.println("Service value not recognized: " + string);
            return false;
        }
        ssl_ = commandLineArguments.isOptionSpecified("-ssl");
        String string2 = commandLineArguments.getOptionValue("-timeout");
        if (string2 != null) {
            time_ = new Integer(string2).intValue();
        }
        verbose_ = commandLineArguments.isOptionSpecified("-verbose");
        return true;
    }

    private static int toServiceNumber(String string) {
        String string2 = string.toLowerCase();
        int n = string2.indexOf("file") != -1 || string2.indexOf("ifs") != -1 ? 0 : (string2.indexOf("prt") != -1 || string2.indexOf("print") != -1 ? 1 : (string2.indexOf("cmd") != -1 || string2.indexOf("command") != -1 ? 2 : (string2.indexOf("dtaq") != -1 || string2.indexOf("dq") != -1 ? 3 : (string2.indexOf("database") != -1 || string2.indexOf("db") != -1 ? 4 : (string2.indexOf("ddm") != -1 || string2.indexOf("rla") != -1 ? 5 : (string2.indexOf("central") != -1 ? 6 : (string2.indexOf("sign") != -1 ? 7 : -1)))))));
        return n;
    }

    static void usage(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(resource_.getString("JPING_USAGE"));
        printWriter.println(resource_.getString("JPING_HELP"));
        printWriter.println(resource_.getString("JPING_SERVICE") + resource_.getString("JPING_SERVICE2") + resource_.getString("JPING_SERVICE3"));
        printWriter.println(resource_.getString("JPING_SSL"));
        printWriter.println(resource_.getString("JPING_TIMEOUT"));
        printWriter.println(resource_.getString("JPING_VERBOSE"));
    }

    static {
        srv_ = 99;
        ssl_ = false;
        verbose_ = false;
        time_ = 20000L;
        resource_ = ResourceBundle.getBundle("com.ibm.as400.util.UTMRI");
    }
}

