/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.micro.JdbcMeService;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

class StatementHandler {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JdbcMeService service_;
    private MicroDataInputStream in_;
    private MicroDataOutputStream out_;

    public StatementHandler(JdbcMeService jdbcMeService, MicroDataInputStream microDataInputStream, MicroDataOutputStream microDataOutputStream) {
        this.service_ = jdbcMeService;
        this.in_ = microDataInputStream;
        this.out_ = microDataOutputStream;
    }

    public void process(Statement statement, int n) throws IOException {
        switch (n) {
            case 4705: {
                this.close(statement);
                break;
            }
            case 4706: {
                this.execute(statement);
                break;
            }
            default: {
                System.out.println("Error - Statement Function ID not recognized - function code: " + n);
            }
        }
    }

    public void close(Statement statement) throws IOException {
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("Exception caught trying to close Statement object " + statement);
            sQLException.printStackTrace();
        }
        this.service_.removeStatement(statement);
    }

    public void execute(Statement statement) throws IOException {
        try {
            String string = this.in_.readUTF();
            boolean bl = statement.execute(string);
            if (bl) {
                this.out_.writeInt(1);
                ResultSet resultSet = statement.getResultSet();
                this.service_.addResultSet(statement, resultSet);
                int n = this.service_.mapObject(resultSet);
                this.out_.writeInt(n);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                this.out_.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    this.out_.writeInt(resultSetMetaData.getColumnType(i + 1));
                }
            } else {
                this.out_.writeInt(0);
                this.out_.writeInt(statement.getUpdateCount());
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }
}

