/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PanelGroupHelpIdentifier;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class PanelGroup
implements Serializable {
    static final long serialVersionUID = 6L;
    private AS400 system_;
    private String path_;
    private transient PropertyChangeSupport propertyChangeListeners_ = new PropertyChangeSupport(this);

    public PanelGroup() {
        this.initializeTransient();
    }

    public PanelGroup(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName.validatePath(string, "PNLGRP");
        this.system_ = aS400;
        this.path_ = string;
        this.initializeTransient();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized PanelGroupHelpIdentifier[] getHelpIdentifiers(String[] stringArray) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        int n;
        if (stringArray == null) {
            throw new NullPointerException("keywords");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving help identifiers for " + stringArray.length + " keywords: ");
            for (int i = 0; i < stringArray.length; ++i) {
                Trace.log(1, stringArray[i]);
            }
        }
        CharConverter charConverter = new CharConverter(this.system_.getCcsid());
        int n2 = stringArray.length;
        int n3 = 28 + 200 * n2;
        int n4 = 8192;
        ProgramParameter[] programParameterArray = new ProgramParameter[8];
        programParameterArray[0] = new ProgramParameter(n3);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        programParameterArray[2] = new ProgramParameter(charConverter.stringToByteArray("RHLP0100"));
        byte[] byArray = new byte[n2 * 80];
        int n5 = 0;
        AS400Text aS400Text = new AS400Text(32, this.system_.getCcsid());
        AS400Text aS400Text2 = new AS400Text(10, this.system_.getCcsid());
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.path_);
        byte[] byArray2 = aS400Text2.toBytes(qSYSObjectPathName.getObjectName().toUpperCase().trim());
        byte[] byArray3 = aS400Text2.toBytes(qSYSObjectPathName.getLibraryName().toUpperCase().trim());
        byte[] byArray4 = aS400Text2.toBytes("*PNLGRP");
        byte[] byArray5 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        for (int i = 0; i < n2; ++i) {
            aS400Text.toBytes(stringArray[i], byArray, n5);
            System.arraycopy(byArray2, 0, byArray, n5 += 32, 10);
            System.arraycopy(byArray3, 0, byArray, n5 += 10, 10);
            System.arraycopy(byArray4, 0, byArray, n5 += 10, 10);
            System.arraycopy(byArray5, 0, byArray, n5 += 10, 18);
            n5 += 18;
        }
        programParameterArray[3] = new ProgramParameter(byArray);
        programParameterArray[4] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        programParameterArray[5] = new ProgramParameter(n4);
        programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(n4));
        programParameterArray[7] = new ProgramParameter(4);
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QUHRHLPT.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray6 = programParameterArray[0].getOutputData();
        int n6 = BinaryConverter.byteArrayToInt(byArray6, 0);
        if (n6 < (n = BinaryConverter.byteArrayToInt(byArray6, 4))) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Performing secondary program call to retrieve help identifiers.");
                }
                programParameterArray[0].setOutputDataLength(n + 8);
                programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n + 8));
                if (!programCall.run()) {
                    throw new AS400Exception(programCall.getMessageList());
                }
                byArray6 = programParameterArray[0].getOutputData();
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, propertyVetoException);
            }
        }
        n5 = BinaryConverter.byteArrayToInt(byArray6, 16);
        int n7 = BinaryConverter.byteArrayToInt(byArray6, 20);
        int n8 = BinaryConverter.byteArrayToInt(byArray6, 24);
        PanelGroupHelpIdentifier[] panelGroupHelpIdentifierArray = new PanelGroupHelpIdentifier[n7];
        for (int i = 0; i < n7; ++i) {
            String string = charConverter.byteArrayToString(byArray6, n5, 32).trim();
            String string2 = charConverter.byteArrayToString(byArray6, n5 + 32, 10).trim();
            String string3 = charConverter.byteArrayToString(byArray6, n5 + 42, 10).trim();
            String string4 = charConverter.byteArrayToString(byArray6, n5 + 52, 10).trim();
            if (string4.startsWith("*")) {
                string4 = string4.substring(1);
            }
            String string5 = charConverter.byteArrayToString(byArray6, n5 + 62, 1);
            String string6 = charConverter.byteArrayToString(byArray6, n5 + 63, 96).trim();
            panelGroupHelpIdentifierArray[i] = new PanelGroupHelpIdentifier(string, string2, string3, string4, string5, string6);
            n5 += n8;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Successfully retrieved help identifiers.");
        }
        return panelGroupHelpIdentifierArray;
    }

    public synchronized String getHelpText(String[] stringArray) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String string;
        if (stringArray == null) {
            throw new NullPointerException("keywords");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving help text for " + stringArray.length + " keywords: ");
            for (int i = 0; i < stringArray.length; ++i) {
                Trace.log(1, stringArray[i]);
            }
        }
        CharConverter charConverter = new CharConverter(this.system_.getCcsid());
        int n = stringArray.length;
        int n2 = 32 + 192 * n;
        int n3 = 8192;
        ProgramParameter[] programParameterArray = new ProgramParameter[8];
        programParameterArray[0] = new ProgramParameter(n2);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        programParameterArray[2] = new ProgramParameter(charConverter.stringToByteArray("RHLP0100"));
        byte[] byArray = new byte[n * 80];
        int n4 = 0;
        AS400Text aS400Text = new AS400Text(32, this.system_.getCcsid());
        AS400Text aS400Text2 = new AS400Text(10, this.system_.getCcsid());
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.path_);
        byte[] byArray2 = aS400Text2.toBytes(qSYSObjectPathName.getObjectName().toUpperCase().trim());
        byte[] byArray3 = aS400Text2.toBytes(qSYSObjectPathName.getLibraryName().toUpperCase().trim());
        byte[] byArray4 = aS400Text2.toBytes("*PNLGRP");
        byte[] byArray5 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        for (int i = 0; i < n; ++i) {
            aS400Text.toBytes(stringArray[i], byArray, n4);
            System.arraycopy(byArray2, 0, byArray, n4 += 32, 10);
            System.arraycopy(byArray3, 0, byArray, n4 += 10, 10);
            System.arraycopy(byArray4, 0, byArray, n4 += 10, 10);
            System.arraycopy(byArray5, 0, byArray, n4 += 10, 18);
            n4 += 18;
        }
        programParameterArray[3] = new ProgramParameter(byArray);
        programParameterArray[4] = new ProgramParameter(BinaryConverter.intToByteArray(n));
        programParameterArray[5] = new ProgramParameter(n3);
        programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        programParameterArray[7] = new ProgramParameter(4);
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QUHRHLPT.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray6 = programParameterArray[0].getOutputData();
        byte[] byArray7 = programParameterArray[5].getOutputData();
        int n5 = BinaryConverter.byteArrayToInt(byArray6, 0);
        int n6 = BinaryConverter.byteArrayToInt(byArray6, 4);
        int n7 = BinaryConverter.byteArrayToInt(byArray7, 0);
        int n8 = BinaryConverter.byteArrayToInt(byArray7, 4);
        if (n5 < n6 || n7 < n8) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Performing secondary program call to retrieve help text.");
                }
                programParameterArray[0].setOutputDataLength(n6 + 8);
                programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n6 + 8));
                programParameterArray[5].setOutputDataLength(n8 + 8);
                programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(n8 + 8));
                if (!programCall.run()) {
                    throw new AS400Exception(programCall.getMessageList());
                }
                byArray7 = programParameterArray[5].getOutputData();
                n7 = BinaryConverter.byteArrayToInt(byArray7, 0);
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, propertyVetoException);
            }
        }
        ConvTable convTable = ConvTable.getTable(1208, null);
        String string2 = string = n7 <= 8 ? "" : convTable.byteArrayToString(byArray7, 8, n7 - 8, 0);
        if (Trace.traceOn_) {
            Trace.log(1, "Successfully retrieved help text.");
        }
        return string;
    }

    public String getPath() {
        return this.path_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.propertyChangeListeners_ = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        PanelGroup panelGroup = this;
        synchronized (panelGroup) {
            QSYSObjectPathName.validatePath(string, "PNLGRP");
            String string2 = this.path_;
            this.path_ = string;
            this.propertyChangeListeners_.firePropertyChange("path", string2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        PanelGroup panelGroup = this;
        synchronized (panelGroup) {
            AS400 aS4002 = this.system_;
            this.system_ = aS400;
            this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS400);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.path_ + "]";
    }
}

