/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class FileEditCommentDetails {
    protected final String commentText;
    protected final String previousCommentText;

    public FileEditCommentDetails(String previousCommentText, String commentText) {
        this.commentText = commentText;
        if (previousCommentText == null) {
            throw new IllegalArgumentException("Required value for 'previousCommentText' is null");
        }
        this.previousCommentText = previousCommentText;
    }

    public FileEditCommentDetails(String previousCommentText) {
        this(previousCommentText, null);
    }

    public String getPreviousCommentText() {
        return this.previousCommentText;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.commentText, this.previousCommentText});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileEditCommentDetails other = (FileEditCommentDetails)obj;
            return (this.previousCommentText == other.previousCommentText || this.previousCommentText.equals(other.previousCommentText)) && (this.commentText == other.commentText || this.commentText != null && this.commentText.equals(other.commentText));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileEditCommentDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileEditCommentDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("previous_comment_text");
            StoneSerializers.string().serialize(value.previousCommentText, g);
            if (value.commentText != null) {
                g.writeFieldName("comment_text");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.commentText, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileEditCommentDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_commentText;
            String f_previousCommentText;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_previousCommentText = null;
                f_commentText = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("previous_comment_text".equals(field)) {
                        f_previousCommentText = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("comment_text".equals(field)) {
                        f_commentText = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_previousCommentText == null) {
                    throw new JsonParseException(p, "Required field \"previous_comment_text\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileEditCommentDetails value = new FileEditCommentDetails(f_previousCommentText, f_commentText);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

