/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.oracle;

import java.sql.ResultSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.database.SqlScriptParser;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;

@DatabaseMetaPlugin(type="ORACLE", typeDescription="Oracle", documentationUrl="/database/databases/oracle.html")
@GuiPlugin(id="GUI-OracleDatabaseMeta")
public class OracleDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    private static final String STRICT_BIGNUMBER_INTERPRETATION = "STRICT_NUMBER_38_INTERPRETATION";

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1521;
        }
        return -1;
    }

    public boolean isSupportsAutoInc() {
        return false;
    }

    public String getLimitClause(int nrRows) {
        return " WHERE ROWNUM <= " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " WHERE 1=0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnName, String tableName) {
        return this.getSqlQueryColumnFields(columnName, tableName);
    }

    public String getSqlQueryColumnFields(String columnName, String tableName) {
        return "SELECT " + columnName + " FROM " + tableName + " WHERE 1=0";
    }

    public String getDriverClass() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    public String getURL(String hostname, String port, String databaseName) throws HopDatabaseException {
        if (this.getAccessType() == 0) {
            if (!Utils.isEmpty((CharSequence)databaseName) && (databaseName.startsWith("/") || databaseName.startsWith(":"))) {
                return "jdbc:oracle:thin:@" + hostname + ":" + port + databaseName;
            }
            if (Utils.isEmpty((CharSequence)hostname) && (Utils.isEmpty((CharSequence)port) || port.equals("-1"))) {
                return "jdbc:oracle:thin:@" + databaseName;
            }
            return "jdbc:oracle:thin:@" + hostname + ":" + port + ":" + databaseName;
        }
        if (databaseName != null && databaseName.length() > 0) {
            if (hostname != null && hostname.length() > 0 && port != null && port.length() > 0) {
                return "jdbc:oracle:oci:@(description=(address=(host=" + hostname + ")(protocol=tcp)(port=" + port + "))(connect_data=(sid=" + databaseName + ")))";
            }
            return "jdbc:oracle:oci:@" + databaseName;
        }
        throw new HopDatabaseException("Unable to construct a JDBC URL: at least the database name must be specified");
    }

    public boolean isSupportsOptionsInURL() {
        return false;
    }

    public boolean isSupportsSequences() {
        return true;
    }

    public String getSqlSequenceExists(String sequenceName) {
        int dotPos = sequenceName.indexOf(46);
        Object sql = "";
        if (dotPos == -1) {
            sql = "SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName.toUpperCase() + "'";
        } else {
            String schemaName = sequenceName.substring(0, dotPos);
            String seqName = sequenceName.substring(dotPos + 1);
            sql = "SELECT * FROM ALL_SEQUENCES WHERE SEQUENCE_NAME = '" + seqName.toUpperCase() + "' AND SEQUENCE_OWNER = '" + schemaName.toUpperCase() + "'";
        }
        return sql;
    }

    public String getSqlCurrentSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".currval FROM DUAL";
    }

    public String getSqlNextSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".nextval FROM DUAL";
    }

    public boolean isSupportsSequenceNoMaxValueOption() {
        return true;
    }

    public boolean useSchemaNameForTableList() {
        return true;
    }

    public boolean isSupportsSynonyms() {
        return true;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD ( " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false) + " ) ";
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP ( " + v.getName() + " ) " + Const.CR;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        boolean isQuoted;
        IValueMeta tmpColumn = v.clone();
        Object tmpName = v.getName();
        boolean bl = isQuoted = ((String)tmpName).startsWith("\"") && ((String)tmpName).endsWith("\"");
        if (isQuoted) {
            tmpName = ((String)tmpName).substring(1, ((String)tmpName).length() - 1);
        }
        int threeoh = ((String)tmpName).length() >= 30 ? 30 : ((String)tmpName).length();
        tmpName = ((String)tmpName).substring(0, threeoh);
        tmpName = (String)tmpName + "_KTL";
        if (isQuoted) {
            tmpName = "\"" + (String)tmpName + "\"";
        }
        tmpColumn.setName((String)tmpName);
        Object sql = "";
        sql = (String)sql + this.getAddColumnStatement(tableName, tmpColumn, tk, useAutoinc, pk, semicolon) + ";" + Const.CR;
        sql = (String)sql + "UPDATE " + tableName + " SET " + tmpColumn.getName() + "=" + v.getName() + ";" + Const.CR;
        sql = (String)sql + this.getDropColumnStatement(tableName, v, tk, useAutoinc, pk, semicolon) + ";" + Const.CR;
        sql = (String)sql + this.getAddColumnStatement(tableName, v, tk, useAutoinc, pk, semicolon) + ";" + Const.CR;
        sql = (String)sql + "UPDATE " + tableName + " SET " + v.getName() + "=" + tmpColumn.getName() + ";" + Const.CR;
        sql = (String)sql + this.getDropColumnStatement(tableName, tmpColumn, tk, useAutoinc, pk, semicolon);
        return sql;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCR) {
        StringBuilder retval = new StringBuilder(128);
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 9: {
                if (this.isSupportsTimestampDataType()) {
                    retval.append("TIMESTAMP");
                    break;
                }
                retval.append("DATE");
                break;
            }
            case 3: {
                retval.append("DATE");
                break;
            }
            case 4: {
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 6: {
                retval.append("NUMBER");
                if (length <= 0) break;
                retval.append('(').append(length);
                if (precision > 0) {
                    retval.append(", ").append(precision);
                }
                retval.append(')');
                break;
            }
            case 5: {
                retval.append("INTEGER");
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval.append("CLOB");
                    break;
                }
                if (length == 1) {
                    retval.append("CHAR(1)");
                    break;
                }
                if (length > 0 && length <= this.getMaxVARCHARLength()) {
                    retval.append("VARCHAR2(").append(length).append(')');
                    break;
                }
                if (length <= 0) {
                    retval.append("VARCHAR2(2000)");
                    break;
                }
                retval.append("CLOB");
                break;
            }
            case 8: {
                retval.append("BLOB");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (addCR) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    public String[] getReservedWords() {
        return new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    }

    public String getSqlListOfProcedures() {
        return "SELECT DISTINCT DECODE(package_name, NULL, '', package_name||'.') || object_name FROM user_arguments ORDER BY 1";
    }

    public String getSqlLockTables(String[] tableNames) {
        StringBuilder sql = new StringBuilder(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("LOCK TABLE ").append(tableNames[i]).append(" IN EXCLUSIVE MODE;").append(Const.CR);
        }
        return sql.toString();
    }

    public String getSqlUnlockTables(String[] tableNames) {
        return null;
    }

    public String getExtraOptionsHelpText() {
        return "http://download.oracle.com/docs/cd/B19306_01/java.102/b14355/urls.htm#i1006362";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasIndex(Database database, String schemaName, String tableName, String[] idxFields) throws HopDatabaseException {
        String schemaTable = database.getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)database, schemaName, tableName);
        boolean[] exists = new boolean[idxFields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            String sql = "SELECT * FROM USER_IND_COLUMNS WHERE TABLE_NAME = '" + schemaTable + "'";
            ResultSet res = null;
            try {
                res = database.openQuery(sql);
                if (res == null) {
                    boolean row22 = false;
                    return row22;
                }
                Object[] row22 = database.getRow(res);
                while (row22 != null) {
                    String column = database.getReturnRowMeta().getString(row22, "COLUMN_NAME", "");
                    int idx = Const.indexOfString((String)column, (String[])idxFields);
                    if (idx >= 0) {
                        exists[idx] = true;
                    }
                    row22 = database.getRow(res);
                }
            }
            finally {
                if (res != null) {
                    database.closeQuery(res);
                }
            }
            boolean all = true;
            int i = 0;
            while (i < exists.length) {
                if (!all) return all;
                if (!exists[i]) {
                    all = false;
                }
                ++i;
            }
            return all;
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unable to determine if indexes exists on table [" + schemaTable + "]", (Throwable)e);
        }
    }

    public boolean isRequiresCreateTablePrimaryKeyAppend() {
        return true;
    }

    public boolean isSupportsPreparedStatementMetadataRetrieval() {
        return false;
    }

    public int getMaxColumnsInIndex() {
        return 32;
    }

    public String getSqlListOfSequences() {
        return "SELECT SEQUENCE_NAME FROM all_sequences";
    }

    public String quoteSqlString(String string) {
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\\n", "'||chr(13)||'");
        string = string.replaceAll("\\r", "'||chr(10)||'");
        return "'" + string + "'";
    }

    public boolean isReleaseSavepoint() {
        return false;
    }

    public String getTablespaceDDL(IVariables variables, DatabaseMeta databaseMeta, String tablespace) {
        if (!Utils.isEmpty((CharSequence)tablespace)) {
            return "TABLESPACE " + databaseMeta.quoteField(variables.resolve(tablespace));
        }
        return "";
    }

    public boolean IsSupportsErrorHandlingOnBatchUpdates() {
        return false;
    }

    public int getMaxVARCHARLength() {
        return 2000;
    }

    public String getDropTableIfExistsStatement(String tableName) {
        return "BEGIN EXECUTE IMMEDIATE 'DROP TABLE " + tableName + "'; EXCEPTION WHEN OTHERS THEN IF SQLCODE != -942 THEN RAISE; END IF; END;";
    }

    public SqlScriptParser createSqlScriptParser() {
        return new SqlScriptParser(false);
    }

    public boolean isStrictBigNumberInterpretation() {
        return "Y".equalsIgnoreCase(this.getAttributeProperty(STRICT_BIGNUMBER_INTERPRETATION, "N"));
    }

    public void setStrictBigNumberInterpretation(boolean strictBigNumberInterpretation) {
        this.getAttributes().put(STRICT_BIGNUMBER_INTERPRETATION, strictBigNumberInterpretation ? "Y" : "N");
    }

    public boolean isOracleVariant() {
        return true;
    }

    public String getStartQuote() {
        return "\"";
    }

    public String getEndQuote() {
        return "\"";
    }
}

