/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.switchcase;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.switchcase.ContainsKeyToRowSetMap;
import org.apache.hop.pipeline.transforms.switchcase.KeyToRowSetMap;
import org.apache.hop.pipeline.transforms.switchcase.SwitchCaseData;
import org.apache.hop.pipeline.transforms.switchcase.SwitchCaseMeta;
import org.apache.hop.pipeline.transforms.switchcase.SwitchCaseTarget;

public class SwitchCase
extends BaseTransform<SwitchCaseMeta, SwitchCaseData> {
    private static final Class<?> PKG = SwitchCaseMeta.class;

    public SwitchCase(TransformMeta transformMeta, SwitchCaseMeta meta, SwitchCaseData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Set<IRowSet> rowSetSet;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.createOutputValueMapping();
        }
        Object lookupData = ((SwitchCaseData)this.data).valueMeta.convertData(((SwitchCaseData)this.data).inputValueMeta, r[((SwitchCaseData)this.data).fieldIndex]);
        Set<IRowSet> set = rowSetSet = ((SwitchCaseData)this.data).valueMeta.isNull(lookupData = SwitchCase.prepareObjectType(lookupData)) ? ((SwitchCaseData)this.data).nullRowSetSet : ((SwitchCaseData)this.data).outputMap.get(lookupData);
        if (rowSetSet == null) {
            rowSetSet = ((SwitchCaseData)this.data).defaultRowSetSet;
        }
        for (IRowSet rowSet : rowSetSet) {
            this.putRowTo(((SwitchCaseData)this.data).outputRowMeta, r, rowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SwitchCase.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        KeyToRowSetMap keyToRowSetMap = ((SwitchCaseData)this.data).outputMap = ((SwitchCaseMeta)this.meta).isUsingContains() ? new ContainsKeyToRowSetMap() : new KeyToRowSetMap();
        if (Utils.isEmpty((CharSequence)((SwitchCaseMeta)this.meta).getFieldName())) {
            this.logError(BaseMessages.getString(PKG, (String)"SwitchCase.Log.NoFieldSpecifiedToSwitchWith", (String[])new String[0]));
            return false;
        }
        try {
            int type = ValueMetaFactory.getIdForValueMeta((String)((SwitchCaseMeta)this.meta).getCaseValueType());
            ((SwitchCaseData)this.data).valueMeta = ValueMetaFactory.createValueMeta((String)((SwitchCaseMeta)this.meta).getFieldName(), (int)type);
            ((SwitchCaseData)this.data).valueMeta.setConversionMask(((SwitchCaseMeta)this.meta).getCaseValueFormat());
            ((SwitchCaseData)this.data).valueMeta.setGroupingSymbol(((SwitchCaseMeta)this.meta).getCaseValueGroup());
            ((SwitchCaseData)this.data).valueMeta.setDecimalSymbol(((SwitchCaseMeta)this.meta).getCaseValueDecimal());
            ((SwitchCaseData)this.data).stringValueMeta = ValueMetaFactory.cloneValueMeta((IValueMeta)((SwitchCaseData)this.data).valueMeta, (int)2);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnexpectedError", (Object[])new Object[]{e}));
        }
        return true;
    }

    void createOutputValueMapping() throws HopException {
        ((SwitchCaseData)this.data).outputRowMeta = this.getInputRowMeta().clone();
        ((SwitchCaseMeta)this.meta).getFields(this.getInputRowMeta(), this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        ((SwitchCaseData)this.data).fieldIndex = this.getInputRowMeta().indexOfValue(((SwitchCaseMeta)this.meta).getFieldName());
        if (((SwitchCaseData)this.data).fieldIndex < 0) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SwitchCase.Exception.UnableToFindFieldName", (String[])new String[]{((SwitchCaseMeta)this.meta).getFieldName()}));
        }
        ((SwitchCaseData)this.data).inputValueMeta = this.getInputRowMeta().getValueMeta(((SwitchCaseData)this.data).fieldIndex);
        try {
            IRowSet rowSet;
            for (SwitchCaseTarget target : ((SwitchCaseMeta)this.meta).getCaseTargets()) {
                if (StringUtils.isEmpty((String)target.getCaseTargetTransformName())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.NoTargetTransformSpecifiedForValue", (String[])new String[]{target.getCaseValue()}));
                }
                IRowSet rowSet2 = this.findOutputRowSet(target.getCaseTargetTransformName());
                if (rowSet2 == null) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnableToFindTargetRowSetForTransform", (String[])new String[]{target.getCaseTargetTransformName()}));
                }
                try {
                    Object value = ((SwitchCaseData)this.data).valueMeta.convertDataFromString(target.getCaseValue(), ((SwitchCaseData)this.data).stringValueMeta, null, null, 0);
                    if (((SwitchCaseData)this.data).valueMeta.isNull(value)) {
                        ((SwitchCaseData)this.data).nullRowSetSet.add(rowSet2);
                        continue;
                    }
                    value = SwitchCase.prepareObjectType(value);
                    ((SwitchCaseData)this.data).outputMap.put(value, rowSet2);
                }
                catch (Exception e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnableToConvertValue", (String[])new String[]{target.getCaseValue()}), (Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty((String)((SwitchCaseMeta)this.meta).getDefaultTargetTransformName()) && (rowSet = this.findOutputRowSet(((SwitchCaseMeta)this.meta).getDefaultTargetTransformName())) != null) {
                ((SwitchCaseData)this.data).defaultRowSetSet.add(rowSet);
                if (((SwitchCaseData)this.data).nullRowSetSet.isEmpty()) {
                    ((SwitchCaseData)this.data).nullRowSetSet.add(rowSet);
                }
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    protected static Object prepareObjectType(Object o) {
        return o instanceof byte[] ? Integer.valueOf(Arrays.hashCode((byte[])o)) : o;
    }
}

