/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.core.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.neo4j.core.data.GraphNodeData;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphRelationshipData;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

public class GraphData {
    protected List<GraphNodeData> nodes = new ArrayList<GraphNodeData>();
    protected List<GraphRelationshipData> relationships = new ArrayList<GraphRelationshipData>();
    protected String sourcePipelineName;
    protected String sourceTransformName;

    public GraphData() {
    }

    public GraphData(List<GraphNodeData> nodes, List<GraphRelationshipData> relationships) {
        this();
        this.nodes = nodes;
        this.relationships = relationships;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GraphData)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        throw new RuntimeException("equals() not yet implemented on GraphData");
    }

    public GraphData(GraphData source) {
        this();
        this.replace(source);
    }

    public void replace(GraphData source) {
        this.nodes = new ArrayList<GraphNodeData>();
        for (GraphNodeData node : source.getNodes()) {
            this.nodes.add(new GraphNodeData(node));
        }
        this.relationships = new ArrayList<GraphRelationshipData>();
        for (GraphRelationshipData relationship : source.getRelationships()) {
            this.relationships.add(new GraphRelationshipData(relationship));
        }
        this.sourcePipelineName = source.sourcePipelineName;
        this.sourceTransformName = source.sourceTransformName;
    }

    public JSONObject toJson() {
        JSONObject jGraph = new JSONObject();
        JSONArray jNodes = new JSONArray();
        jGraph.put((Object)"nodes", (Object)jNodes);
        for (GraphNodeData node : this.nodes) {
            jNodes.add((Object)node.toJson());
        }
        JSONArray jRelationships = new JSONArray();
        jGraph.put((Object)"relationships", (Object)jRelationships);
        for (GraphRelationshipData relationship : this.relationships) {
            jRelationships.add((Object)relationship.toJson());
        }
        jGraph.put((Object)"source_pipeline", (Object)this.sourcePipelineName);
        jGraph.put((Object)"source_transform", (Object)this.sourceTransformName);
        return jGraph;
    }

    public GraphData(String graphJsonString) throws ParseException {
        this((JSONObject)new JSONParser().parse(graphJsonString));
    }

    public GraphData(JSONObject jGraph) {
        this();
        JSONArray jNodes = (JSONArray)jGraph.get((Object)"nodes");
        for (int i = 0; i < jNodes.size(); ++i) {
            JSONObject jNode = (JSONObject)jNodes.get(i);
            this.nodes.add(new GraphNodeData(jNode));
        }
        JSONArray jRelationships = (JSONArray)jGraph.get((Object)"relationships");
        for (int i = 0; i < jRelationships.size(); ++i) {
            JSONObject jRelationship = (JSONObject)jRelationships.get(i);
            this.relationships.add(new GraphRelationshipData(jRelationship));
        }
        this.sourcePipelineName = (String)jGraph.get((Object)"source_pipeline");
        this.sourceTransformName = (String)jGraph.get((Object)"source_transform");
    }

    public String toJsonString() {
        return this.toJson().toJSONString();
    }

    public GraphData clone() {
        return new GraphData(this);
    }

    public GraphData createEmptyCopy() {
        GraphData copy = new GraphData();
        copy.setSourcePipelineName(this.getSourcePipelineName());
        copy.setSourceTransformName(this.getSourceTransformName());
        return copy;
    }

    public GraphNodeData findNode(String nodeId) {
        for (GraphNodeData node : this.nodes) {
            if (node.getId() == null || !node.getId().equals(nodeId)) continue;
            return node;
        }
        return null;
    }

    public GraphRelationshipData findRelationship(String relationshipId) {
        for (GraphRelationshipData relationship : this.relationships) {
            if (relationship.getId() == null || !relationship.getId().equals(relationshipId)) continue;
            return relationship;
        }
        return null;
    }

    public GraphRelationshipData findRelationship(String sourceId, String targetId) {
        for (GraphRelationshipData relationship : this.relationships) {
            if (relationship.getSourceNodeId().equals(sourceId) && relationship.getTargetNodeId().equals(targetId)) {
                return relationship;
            }
            if (!relationship.getSourceNodeId().equals(targetId) || !relationship.getTargetNodeId().equals(sourceId)) continue;
            return relationship;
        }
        return null;
    }

    public GraphData(Result result) {
        this();
        while (result.hasNext()) {
            Record record = result.next();
            for (String key : record.keys()) {
                Value value = record.get(key);
                if ("NODE".equals(value.type().name())) {
                    this.update(value.asNode());
                    continue;
                }
                if ("RELATIONSHIP".equals(value.type().name())) {
                    this.update(value.asRelationship());
                    continue;
                }
                if (!"PATH".equals(value.type().name())) continue;
                this.update(value.asPath());
            }
        }
    }

    public void update(GraphNodeData dataNode) {
        int index = this.nodes.indexOf(dataNode);
        if (index < 0) {
            this.nodes.add(dataNode);
        } else {
            this.nodes.set(index, dataNode);
        }
    }

    public void update(GraphRelationshipData dataRelationship) {
        int index = this.relationships.indexOf(dataRelationship);
        if (index < 0) {
            this.relationships.add(dataRelationship);
        } else {
            this.relationships.set(index, dataRelationship);
        }
    }

    public void update(Node node) {
        this.update(new GraphNodeData(node));
    }

    public void update(Relationship relationship) {
        this.update(new GraphRelationshipData(relationship));
    }

    public void update(Path path) {
        for (Node node : path.nodes()) {
            this.update(node);
        }
        for (Relationship relationship : path.relationships()) {
            this.update(relationship);
        }
    }

    public GraphNodeData findNodeWithProperty(String propertyId, Object value) {
        for (GraphNodeData node : this.nodes) {
            GraphPropertyData property = node.findProperty(propertyId);
            if (property == null || property.getValue() == null || !property.getValue().equals(value)) continue;
            return node;
        }
        return null;
    }

    public List<GraphRelationshipData> findRelationships(String label) {
        ArrayList<GraphRelationshipData> rels = new ArrayList<GraphRelationshipData>();
        for (GraphRelationshipData relationship : this.relationships) {
            if (!relationship.getLabel().equals(label)) continue;
            rels.add(relationship);
        }
        return rels;
    }

    public GraphNodeData findTopNode(String labelToFollow) {
        List<GraphRelationshipData> rels = this.findRelationships(labelToFollow);
        if (rels.size() == 0) {
            return null;
        }
        GraphRelationshipData rel = rels.get(0);
        GraphNodeData node = null;
        while (rel != null) {
            node = this.findNode(rel.getSourceNodeId());
            rel = this.findRelationshipsWithTarget(rels, node.getId());
        }
        return node;
    }

    public GraphRelationshipData findRelationshipsWithTarget(List<GraphRelationshipData> rels, String targetId) {
        for (GraphRelationshipData relationship : rels) {
            if (!relationship.getTargetNodeId().equals(targetId)) continue;
            return relationship;
        }
        return null;
    }

    public GraphRelationshipData findRelationshipsWithSource(List<GraphRelationshipData> rels, String sourceId) {
        for (GraphRelationshipData relationship : rels) {
            if (!relationship.getSourceNodeId().equals(sourceId)) continue;
            return relationship;
        }
        return null;
    }

    private List<GraphNodeData> getPath(GraphNodeData startNode, String mainRelationshipLabel) {
        GraphNodeData currentNode = startNode;
        GraphNodeData previousNode = null;
        ArrayList<GraphNodeData> path = new ArrayList<GraphNodeData>();
        while (currentNode != null) {
            path.add(currentNode);
            GraphNodeData nextNode = this.findNextNode(currentNode, mainRelationshipLabel, previousNode);
            previousNode = currentNode;
            currentNode = nextNode;
        }
        return path;
    }

    private GraphNodeData getOtherNode(GraphRelationshipData nextRel, GraphNodeData currentNode) {
        if (nextRel.getSourceNodeId().equals(currentNode.getId())) {
            return this.findNode(nextRel.getTargetNodeId());
        }
        if (nextRel.getTargetNodeId().equals(currentNode.getId())) {
            return this.findNode(nextRel.getSourceNodeId());
        }
        return null;
    }

    public int getFirstRelationshipLabelIndex(List<GraphRelationshipData> rels, String mainRelationshipLabel) {
        for (int i = 0; i < rels.size(); ++i) {
            GraphRelationshipData relationship = rels.get(i);
            if (!mainRelationshipLabel.equals(relationship.getLabel())) continue;
            return i;
        }
        return -1;
    }

    private List<GraphNodeData> findNextNodes(GraphNodeData currentNode, String excludeLabel) {
        ArrayList<GraphNodeData> nextNodes = new ArrayList<GraphNodeData>();
        for (GraphRelationshipData relationship : this.relationships) {
            if (relationship.getLabel().equals(excludeLabel)) continue;
            if (relationship.getSourceNodeId().equals(currentNode.getId())) {
                nextNodes.add(this.findNode(relationship.getTargetNodeId()));
            }
            if (!relationship.getTargetNodeId().equals(currentNode.getId())) continue;
            nextNodes.add(this.findNode(relationship.getSourceNodeId()));
        }
        return nextNodes;
    }

    public GraphNodeData findNextNode(GraphNodeData currentNode, String mainRelationshipLabel, GraphNodeData excludeNode) {
        List<GraphRelationshipData> rels = this.findRelationships(currentNode);
        for (GraphRelationshipData rel : rels) {
            if (!mainRelationshipLabel.equals(rel.getLabel()) || excludeNode != null && (rel.getSourceNodeId().equals(excludeNode.getId()) || rel.getTargetNodeId().equals(excludeNode.getId()))) continue;
            if (rel.getSourceNodeId().equals(currentNode.getId())) {
                return this.findNode(rel.getTargetNodeId());
            }
            return this.findNode(rel.getSourceNodeId());
        }
        return null;
    }

    public List<GraphRelationshipData> findRelationships(GraphNodeData dataNode) {
        ArrayList<GraphRelationshipData> found = new ArrayList<GraphRelationshipData>();
        for (GraphRelationshipData relationship : this.relationships) {
            if (!relationship.getSourceNodeId().equals(dataNode.getId()) && !relationship.getTargetNodeId().equals(dataNode.getId())) continue;
            found.add(relationship);
        }
        return found;
    }

    public List<GraphNodeData> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<GraphNodeData> nodes) {
        this.nodes = nodes;
    }

    public List<GraphRelationshipData> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<GraphRelationshipData> relationships) {
        this.relationships = relationships;
    }

    public String getSourcePipelineName() {
        return this.sourcePipelineName;
    }

    public void setSourcePipelineName(String sourcePipelineName) {
        this.sourcePipelineName = sourcePipelineName;
    }

    public String getSourceTransformName() {
        return this.sourceTransformName;
    }

    public void setSourceTransformName(String sourceTransformName) {
        this.sourceTransformName = sourceTransformName;
    }
}

