/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.actions.cypherscript;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.TransactionWork;

@Action(id="NEO4J_CYPHER_SCRIPT", name="Neo4j Cypher Script", description="Execute a Neo4j Cypher script", image="neo4j_cypher.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Scripting", keywords={"i18n::CypherScript.keyword"}, documentationUrl="/workflow/actions/neo4j-cypherscript.html")
public class CypherScript
extends ActionBase
implements IAction {
    @HopMetadataProperty(key="connection")
    private String connectionName;
    @HopMetadataProperty(key="script")
    private String script;
    @HopMetadataProperty(key="replace_variables")
    private boolean replacingVariables;

    public CypherScript() {
        this("", "");
    }

    public CypherScript(String name) {
        this(name, "");
    }

    public CypherScript(String name, String description) {
        super(name, description);
    }

    public CypherScript(CypherScript s) {
        super(s.getName(), s.getDescription(), s.getPluginId());
        this.connectionName = s.connectionName;
        this.script = s.script;
        this.replacingVariables = s.replacingVariables;
    }

    public CypherScript clone() {
        return new CypherScript(this);
    }

    public Result execute(Result result, int nr) throws HopException {
        int nrExecuted;
        NeoConnection connection;
        IHopMetadataSerializer serializer = this.getMetadataProvider().getSerializer(NeoConnection.class);
        String realConnectionName = this.resolve(this.connectionName);
        try {
            if (StringUtils.isEmpty((String)realConnectionName)) {
                throw new HopException("The Neo4j connection name is not set");
            }
            connection = (NeoConnection)serializer.load(realConnectionName);
            if (connection == null) {
                throw new HopException("Unable to find connection with name '" + realConnectionName + "'");
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.increaseErrors(1L);
            throw new HopException("Unable to gencsv or find connection with name '" + realConnectionName + "'", (Throwable)e);
        }
        String realScript = this.replacingVariables ? this.resolve(this.script) : this.script;
        try (Driver driver = connection.getDriver(this.log, (IVariables)this);
             Session session = connection.getSession(this.log, driver, (IVariables)this);){
            TransactionWork transactionWork = transaction -> {
                int executed = 0;
                try {
                    String[] commands;
                    for (String command : commands = realScript.split("\\r?\\n;")) {
                        String cypher = command.replaceFirst("^\\s+", "").replaceFirst("\\s+$", "");
                        if (!StringUtils.isNotEmpty((String)cypher)) continue;
                        transaction.run(cypher);
                        ++executed;
                        this.log.logDetailed("Executed cypher statement: " + cypher);
                    }
                    transaction.commit();
                }
                catch (Exception e) {
                    this.log.logError("Error executing cypher statements...", (Throwable)e);
                    result.increaseErrors(1L);
                    transaction.rollback();
                    result.setResult(false);
                }
                return executed;
            };
            nrExecuted = (Integer)session.writeTransaction(transactionWork);
        }
        if (result.getNrErrors() == 0L) {
            this.logBasic("Neo4j script executed " + nrExecuted + " statements without error");
        } else {
            this.logBasic("Neo4j script executed with error(s)");
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean isReplacingVariables() {
        return this.replacingVariables;
    }

    public void setReplacingVariables(boolean replacingVariables) {
        this.replacingVariables = replacingVariables;
    }
}

