/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.filecompare;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;

@Action(id="FILE_COMPARE", name="i18n::ActionFileCompare.Name", description="i18n::ActionFileCompare.Description", image="FileCompare.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionFileCompare.keyword"}, documentationUrl="/workflow/actions/filecompare.html")
public class ActionFileCompare
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionFileCompare.class;
    @HopMetadataProperty(key="filename1")
    private String filename1;
    @HopMetadataProperty(key="filename2")
    private String filename2;
    @HopMetadataProperty(key="add_filename_result")
    private boolean addFilenameToResult;

    public ActionFileCompare(String n) {
        super(n, "");
        this.filename1 = null;
        this.filename2 = null;
        this.addFilenameToResult = false;
    }

    public ActionFileCompare() {
        this("");
    }

    public ActionFileCompare(ActionFileCompare meta) {
        super(meta.getName(), meta.getDescription(), meta.getPluginId());
        this.filename1 = meta.filename1;
        this.filename2 = meta.filename2;
        this.addFilenameToResult = meta.addFilenameToResult;
    }

    public Object clone() {
        return new ActionFileCompare(this);
    }

    public String getRealFilename1() {
        return this.resolve(this.getFilename1());
    }

    public String getRealFilename2() {
        return this.resolve(this.getFilename2());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equalFileContents(FileObject file1, FileObject file2) throws HopFileException {
        FilterInputStream in1 = null;
        FilterInputStream in2 = null;
        try {
            in1 = new DataInputStream(new BufferedInputStream(HopVfs.getInputStream((String)HopVfs.getFilename((FileObject)file1))));
            in2 = new DataInputStream(new BufferedInputStream(HopVfs.getInputStream((String)HopVfs.getFilename((FileObject)file2))));
            while (in1.available() != 0 && in2.available() != 0) {
                char ch2;
                char ch1 = (char)((DataInputStream)in1).readByte();
                if (ch1 == (ch2 = (char)((DataInputStream)in2).readByte())) continue;
                boolean bl = false;
                return bl;
            }
            if (in1.available() != in2.available()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new HopFileException((Throwable)e);
        }
        finally {
            if (in1 != null) {
                try {
                    in1.close();
                }
                catch (IOException iOException) {}
            }
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        String realFilename1 = this.getRealFilename1();
        String realFilename2 = this.getRealFilename2();
        FileObject file1 = null;
        FileObject file2 = null;
        try {
            if (this.filename1 != null && this.filename2 != null) {
                file1 = HopVfs.getFileObject((String)realFilename1);
                file2 = HopVfs.getFileObject((String)realFilename2);
                if (file1.exists() && file2.exists()) {
                    if (this.equalFileContents(file1, file2)) {
                        result.setResult(true);
                    } else {
                        result.setResult(false);
                    }
                    if (this.addFilenameToResult && file1.getType() == FileType.FILE && file2.getType() == FileType.FILE) {
                        ResultFile resultFile = new ResultFile(0, file1, this.parentWorkflow.getWorkflowName(), this.toString());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"ActionWaitForFile.FilenameAdded", (String[])new String[0]));
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        resultFile = new ResultFile(0, file2, this.parentWorkflow.getWorkflowName(), this.toString());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"ActionWaitForFile.FilenameAdded", (String[])new String[0]));
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    }
                } else {
                    if (!file1.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFileCompare.ERROR_0004_File1_Does_Not_Exist", (String[])new String[]{realFilename1}));
                    }
                    if (!file2.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFileCompare.ERROR_0005_File2_Does_Not_Exist", (String[])new String[]{realFilename2}));
                    }
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"ActionFileCompare.ERROR_0006_Need_Two_Filenames", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"ActionFileCompare.ERROR_0007_Comparing_Files", (String[])new String[]{realFilename2, realFilename2, e.getMessage()}));
        }
        finally {
            try {
                if (file1 != null) {
                    file1.close();
                    file1 = null;
                }
                if (file2 != null) {
                    file2.close();
                    file2 = null;
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void setFilename1(String filename) {
        this.filename1 = filename;
    }

    public String getFilename1() {
        return this.filename1;
    }

    public void setFilename2(String filename) {
        this.filename2 = filename;
    }

    public String getFilename2() {
        return this.filename2;
    }

    public boolean isAddFilenameToResult() {
        return this.addFilenameToResult;
    }

    public void setAddFilenameToResult(boolean addFilenameToResult) {
        this.addFilenameToResult = addFilenameToResult;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename1) && !Utils.isEmpty((CharSequence)this.filename2)) {
            String realFilename1 = this.resolve(this.filename1);
            String realFilename2 = this.resolve(this.filename2);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFilename1, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realFilename2, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename1", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename2", remarks, ctx);
    }
}

