/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.util.Verbose;
import com.sforce.ws.wsdl.Collection;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.Types;
import com.sforce.ws.wsdl.WsdlFactory;
import com.sforce.ws.wsdl.WsdlParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

public class Main {
    public static void main(String[] args) throws WsdlParseException, MalformedURLException, IOException {
        Definitions definitions = WsdlFactory.create(new URL(args[0]));
        Verbose.log(definitions.toString());
        Types types = definitions.getTypes();
        System.out.println("types");
        for (Schema schema : types.getSchemas()) {
            System.out.println("  schema " + schema.getTargetNamespace());
            for (ComplexType type : schema.getComplexTypes()) {
                System.out.println("    " + type.getName() + " extends " + type.getBase());
                Collection sequence = type.getContent();
                if (sequence == null) continue;
                Iterator<Element> elements = sequence.getElements();
                while (elements.hasNext()) {
                    Element element = elements.next();
                    System.out.println("      " + element.getName() + " " + element.getType());
                }
            }
        }
    }
}

