/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricUpdates;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.CommittedResult;
import org.apache.beam.runners.direct.CompletionCallback;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ModelEnforcement;
import org.apache.beam.runners.direct.ModelEnforcementFactory;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorRegistry;
import org.apache.beam.runners.direct.TransformExecutor;
import org.apache.beam.runners.direct.TransformExecutorFactory;
import org.apache.beam.runners.direct.TransformExecutorService;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectTransformExecutor<@UnknownKeyFor T>
implements TransformExecutor {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DirectTransformExecutor.class);
    private final @UnknownKeyFor @NonNull @Initialized TransformEvaluatorRegistry evaluatorRegistry;
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ModelEnforcementFactory> modelEnforcements;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform;
    private final @UnknownKeyFor @NonNull @Initialized CommittedBundle<T> inputBundle;
    private final @UnknownKeyFor @NonNull @Initialized CompletionCallback onComplete;
    private final @UnknownKeyFor @NonNull @Initialized TransformExecutorService transformEvaluationState;
    private final @UnknownKeyFor @NonNull @Initialized EvaluationContext context;

    @VisibleForTesting
    DirectTransformExecutor(@UnknownKeyFor @NonNull @Initialized EvaluationContext context, @UnknownKeyFor @NonNull @Initialized TransformEvaluatorRegistry factory, @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ModelEnforcementFactory> modelEnforcements, @UnknownKeyFor @NonNull @Initialized CommittedBundle<T> inputBundle, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized CompletionCallback completionCallback, @UnknownKeyFor @NonNull @Initialized TransformExecutorService transformEvaluationState) {
        this.evaluatorRegistry = factory;
        this.modelEnforcements = modelEnforcements;
        this.inputBundle = inputBundle;
        this.transform = transform;
        this.onComplete = completionCallback;
        this.transformEvaluationState = transformEvaluationState;
        this.context = context;
    }

    @Override
    public void run() {
        MetricsContainerImpl metricsContainer = new MetricsContainerImpl(this.transform.getFullName());
        try (Closeable metricsScope = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)metricsContainer);){
            ArrayList<ModelEnforcement<T>> enforcements = new ArrayList<ModelEnforcement<T>>();
            for (ModelEnforcementFactory modelEnforcementFactory : this.modelEnforcements) {
                ModelEnforcement<T> enforcement = modelEnforcementFactory.forBundle(this.inputBundle, this.transform);
                enforcements.add(enforcement);
            }
            @Nullable TransformEvaluator<InputT> evaluator = this.evaluatorRegistry.forApplication(this.transform, this.inputBundle);
            if (evaluator == null) {
                this.onComplete.handleEmpty(this.transform);
                return;
            }
            this.processElements(evaluator, metricsContainer, enforcements);
            this.finishBundle(evaluator, metricsContainer, enforcements);
        }
        catch (Exception e) {
            this.onComplete.handleException(this.inputBundle, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        catch (Error err) {
            LOG.error("Error occurred within {}", (Object)this, (Object)err);
            this.onComplete.handleError(err);
            throw err;
        }
        finally {
            this.context.getMetrics().commitPhysical(this.inputBundle, metricsContainer.getCumulative());
            this.transformEvaluationState.complete(this);
        }
    }

    private void processElements(@UnknownKeyFor @NonNull @Initialized TransformEvaluator<T> evaluator, @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl metricsContainer, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ModelEnforcement<T>> enforcements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.inputBundle != null) {
            for (WindowedValue<T> value : this.inputBundle.getElements()) {
                for (ModelEnforcement<T> enforcement : enforcements) {
                    enforcement.beforeElement(value);
                }
                evaluator.processElement(value);
                MetricUpdates deltas = metricsContainer.getUpdates();
                if (deltas != null) {
                    this.context.getMetrics().updatePhysical(this.inputBundle, deltas);
                    metricsContainer.commitUpdates();
                }
                for (ModelEnforcement<T> enforcement : enforcements) {
                    enforcement.afterElement(value);
                }
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized TransformResult<T> finishBundle(@UnknownKeyFor @NonNull @Initialized TransformEvaluator<T> evaluator, @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl metricsContainer, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ModelEnforcement<T>> enforcements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TransformResult<T> result = evaluator.finishBundle().withLogicalMetricUpdates(metricsContainer.getCumulative());
        CommittedResult outputs = this.onComplete.handleResult(this.inputBundle, result);
        for (ModelEnforcement<T> enforcement : enforcements) {
            enforcement.afterFinish(this.inputBundle, result, outputs.getOutputs());
        }
        return result;
    }

    static class Factory
    implements TransformExecutorFactory {
        private final @UnknownKeyFor @NonNull @Initialized EvaluationContext context;
        private final @UnknownKeyFor @NonNull @Initialized TransformEvaluatorRegistry registry;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ModelEnforcementFactory>> transformEnforcements;

        Factory(@UnknownKeyFor @NonNull @Initialized EvaluationContext context, @UnknownKeyFor @NonNull @Initialized TransformEvaluatorRegistry registry, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ModelEnforcementFactory>> transformEnforcements) {
            this.context = context;
            this.registry = registry;
            this.transformEnforcements = transformEnforcements;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TransformExecutor create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized CompletionCallback onComplete, @UnknownKeyFor @NonNull @Initialized TransformExecutorService executorService) {
            Collection enforcements = (Collection)MoreObjects.firstNonNull(this.transformEnforcements.get(PTransformTranslation.urnForTransform(transform.getTransform())), Collections.emptyList());
            return new DirectTransformExecutor(this.context, this.registry, enforcements, bundle, transform, onComplete, executorService);
        }
    }
}

