/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterDelayFromFirstElementStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

public class AfterProcessingTimeStateMachine
extends AfterDelayFromFirstElementStateMachine {
    @Override
    public @Nullable @UnknownKeyFor @Initialized Instant getCurrentTime(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) {
        return context.currentProcessingTime();
    }

    private AfterProcessingTimeStateMachine(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Instant>> transforms) {
        super(TimeDomain.PROCESSING_TIME, transforms);
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterProcessingTimeStateMachine pastFirstElementInPane() {
        return new AfterProcessingTimeStateMachine(IDENTITY);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized AfterProcessingTimeStateMachine newWith(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Instant>> transforms) {
        return new AfterProcessingTimeStateMachine(transforms);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder("AfterProcessingTime.pastFirstElementInPane()");
        for (SerializableFunction delayFn : this.timestampMappers) {
            builder.append(".plusDelayOf(").append(delayFn).append(")");
        }
        return builder.toString();
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterProcessingTimeStateMachine)) {
            return false;
        }
        AfterProcessingTimeStateMachine that = (AfterProcessingTimeStateMachine)obj;
        return Objects.equals(this.timestampMappers, that.timestampMappers);
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getClass(), this.timestampMappers);
    }
}

