/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;

public class VerticesFromEdgesIterable
implements Iterable<Vertex> {
    private final Iterable<Edge> iterable;
    private final Direction direction;
    private final Vertex vertex;

    public VerticesFromEdgesIterable(Vertex vertex, Direction direction, String ... labels) {
        this.direction = direction;
        this.vertex = vertex;
        this.iterable = vertex.getEdges(direction, labels);
    }

    @Override
    public Iterator<Vertex> iterator() {
        return new Iterator<Vertex>(){
            final Iterator<Edge> itty;
            {
                this.itty = VerticesFromEdgesIterable.this.iterable.iterator();
            }

            @Override
            public void remove() {
                this.itty.remove();
            }

            @Override
            public boolean hasNext() {
                return this.itty.hasNext();
            }

            @Override
            public Vertex next() {
                if (VerticesFromEdgesIterable.this.direction.equals((Object)Direction.OUT)) {
                    return this.itty.next().getVertex(Direction.IN);
                }
                if (VerticesFromEdgesIterable.this.direction.equals((Object)Direction.IN)) {
                    return this.itty.next().getVertex(Direction.OUT);
                }
                Edge edge = this.itty.next();
                if (edge.getVertex(Direction.IN).equals(VerticesFromEdgesIterable.this.vertex)) {
                    return edge.getVertex(Direction.OUT);
                }
                return edge.getVertex(Direction.IN);
            }
        };
    }
}

