/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.impls.tg.TinkerMetadataReader;
import com.tinkerpop.blueprints.impls.tg.TinkerMetadataWriter;
import com.tinkerpop.blueprints.impls.tg.TinkerStorage;
import com.tinkerpop.blueprints.util.io.gml.GMLReader;
import com.tinkerpop.blueprints.util.io.gml.GMLWriter;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLReader;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLWriter;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONReader;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

class TinkerStorageFactory {
    private static TinkerStorageFactory factory;

    private TinkerStorageFactory() {
    }

    public static TinkerStorageFactory getInstance() {
        if (factory == null) {
            factory = new TinkerStorageFactory();
        }
        return factory;
    }

    public TinkerStorage getTinkerStorage(TinkerGraph.FileType fileType) {
        switch (fileType) {
            case GML: {
                return new GMLTinkerStorage();
            }
            case GRAPHML: {
                return new GraphMLTinkerStorage();
            }
            case GRAPHSON: {
                return new GraphSONTinkerStorage();
            }
            case JAVA: {
                return new JavaTinkerStorage();
            }
        }
        throw new RuntimeException(String.format("File Type [%s] is not configurable by the factory", new Object[]{fileType}));
    }

    class JavaTinkerStorage
    extends AbstractTinkerStorage {
        private static final String GRAPH_FILE_JAVA = "/tinkergraph.dat";

        JavaTinkerStorage() {
        }

        @Override
        public TinkerGraph load(String directory) throws IOException {
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(directory + GRAPH_FILE_JAVA));
            try {
                TinkerGraph tinkerGraph = (TinkerGraph)input.readObject();
                return tinkerGraph;
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
            finally {
                input.close();
            }
        }

        @Override
        public void save(TinkerGraph graph, String directory) throws IOException {
            this.deleteFile(directory + GRAPH_FILE_JAVA);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(directory + GRAPH_FILE_JAVA));
            try {
                out.writeObject(graph);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                out.close();
            }
        }
    }

    class GraphMLTinkerStorage
    extends AbstractSeparateTinkerStorage {
        private static final String GRAPH_FILE_GRAPHML = "/tinkergraph.xml";

        GraphMLTinkerStorage() {
        }

        @Override
        public void loadGraphData(TinkerGraph graph, String directory) throws IOException {
            GraphMLReader.inputGraph((Graph)graph, new FileInputStream(directory + GRAPH_FILE_GRAPHML));
        }

        @Override
        public void saveGraphData(TinkerGraph graph, String directory) throws IOException {
            this.deleteFile(directory + GRAPH_FILE_GRAPHML);
            FileOutputStream os = new FileOutputStream(directory + GRAPH_FILE_GRAPHML);
            try {
                GraphMLWriter.outputGraph((Graph)graph, os);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    class GraphSONTinkerStorage
    extends AbstractSeparateTinkerStorage {
        private static final String GRAPH_FILE_GRAPHSON = "/tinkergraph.json";

        GraphSONTinkerStorage() {
        }

        @Override
        public void loadGraphData(TinkerGraph graph, String directory) throws IOException {
            GraphSONReader.inputGraph((Graph)graph, new FileInputStream(directory + GRAPH_FILE_GRAPHSON));
        }

        @Override
        public void saveGraphData(TinkerGraph graph, String directory) throws IOException {
            this.deleteFile(directory + GRAPH_FILE_GRAPHSON);
            FileOutputStream os = new FileOutputStream(directory + GRAPH_FILE_GRAPHSON);
            try {
                GraphSONWriter.outputGraph((Graph)graph, os, GraphSONMode.EXTENDED);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    class GMLTinkerStorage
    extends AbstractSeparateTinkerStorage {
        private static final String GRAPH_FILE_GML = "/tinkergraph.gml";

        GMLTinkerStorage() {
        }

        @Override
        public void loadGraphData(TinkerGraph graph, String directory) throws IOException {
            GMLReader.inputGraph((Graph)graph, new FileInputStream(directory + GRAPH_FILE_GML));
        }

        @Override
        public void saveGraphData(TinkerGraph graph, String directory) throws IOException {
            this.deleteFile(directory + GRAPH_FILE_GML);
            FileOutputStream os = new FileOutputStream(directory + GRAPH_FILE_GML);
            try {
                GMLWriter.outputGraph((Graph)graph, os);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    abstract class AbstractSeparateTinkerStorage
    extends AbstractTinkerStorage {
        protected static final String GRAPH_FILE_METADATA = "/tinkergraph-metadata.dat";

        AbstractSeparateTinkerStorage() {
        }

        public abstract void saveGraphData(TinkerGraph var1, String var2) throws IOException;

        public abstract void loadGraphData(TinkerGraph var1, String var2) throws IOException;

        @Override
        public TinkerGraph load(String directory) throws IOException {
            File dir = new File(directory);
            if (!dir.exists()) {
                throw new RuntimeException("Directory " + directory + " does not exist");
            }
            TinkerGraph graph = new TinkerGraph();
            this.loadGraphData(graph, directory);
            File file = new File(directory + GRAPH_FILE_METADATA);
            if (file.exists()) {
                TinkerMetadataReader.load(graph, new FileInputStream(directory + GRAPH_FILE_METADATA));
            }
            return graph;
        }

        @Override
        public void save(TinkerGraph graph, String directory) throws IOException {
            File dir = new File(directory);
            if (!dir.exists() && !dir.mkdir()) {
                throw new RuntimeException("Could not create directory " + directory);
            }
            this.saveGraphData(graph, directory);
            this.deleteFile(directory + GRAPH_FILE_METADATA);
            FileOutputStream os = new FileOutputStream(directory + GRAPH_FILE_METADATA);
            try {
                TinkerMetadataWriter.save(graph, os);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    abstract class AbstractTinkerStorage
    implements TinkerStorage {
        AbstractTinkerStorage() {
        }

        protected void deleteFile(String path) throws IOException {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
        }
    }
}

